package com.clx.performance.controller.pc.loan.owner;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanRecordOfOwner;
import com.clx.performance.service.loan.OwnerLoanRecordService;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanRecordVO;
import com.clx.performance.vo.pc.loan.owner.OwnerLoanRecordDetail;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/owner/loanRecord")
@Validated
@Tag(name = "货主端-资金管理（货主借款账户管理（申请借款））")
@AllArgsConstructor
public class OwnerLoanRecordController {

    private final OwnerLoanRecordService ownerLoanRecordService;



    @Operation(summary = "借款列表",description = "<br>By:刘海泉")
    @PostMapping("/pageOwnerLoanRecordOfOwner")
    @UnitCovert(param = false)
    public Result<PageData<OwnerLoanRecordVO>> pageOwnerLoanRecordOfOwner(@RequestBody @Validated PageOwnerLoanRecordOfOwner param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(loginUserInfo.getCompanyNo());
        IPage<OwnerLoanRecordVO> page = ownerLoanRecordService.pageOwnerLoanRecordOfOwner(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @Operation(summary = "借款详情",description = "<br>By:刘海泉")
    @GetMapping("/getOwnerLoanRecordDetail")
    public Result<OwnerLoanRecordDetail> getOwnerLoanRecordDetail() {
        OwnerLoanRecordDetail detail = ownerLoanRecordService.getOwnerLoanRecordDetail();
        return Result.ok(detail);
    }




}
