package com.clx.performance.controller.pc;

import com.clx.performance.model.OrderChild;
import com.clx.performance.service.LastTruckService;
import com.clx.performance.struct.OrderChildStruct;
import com.clx.performance.vo.app.OrderChildVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import jakarta.validation.constraints.NotBlank;

/**
 * @ClassName OrderWeightController
 * @Description
 * @Author kavin
 * @Date 2024/8/5 11:45
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping(value="/pc/lastTruck")
@Validated
@Tag(name = "最后一车")
@AllArgsConstructor
public class LastTruckController {

    private final LastTruckService lastTruckService;
    private final OrderChildStruct orderChildStruct;


    @Operation(summary = "查询订单下的最后一车",description = "<br>By:刘海泉")
    @GetMapping("/getOrderLastTruck")
    public Result<OrderChildVO> getOrderLastTruck(@RequestParam("orderNo")
    @NotBlank(message = "订单编号不能为空") String orderNo) throws Exception{
        OrderChild child = lastTruckService.getOrderLastTruck(orderNo);
        return Result.ok(orderChildStruct.convert(child));
    }

    @Operation(summary = "手动同步数媒宝最后一车触发",description = "<br>By:刘海泉")
    @GetMapping("/handExecSyncSmbLastTruck")
    public Result<?> handExecSyncSmbLastTruck(
    @RequestParam("orderNo")
    @NotBlank(message = "订单编号不能为空") String orderNo,
    @RequestParam("childNo")
    @NotBlank(message = "运单编号不能为空") String childNo) {
        return lastTruckService.handExecSyncSmbLastTruck(orderNo,childNo);
    }

}
