package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("network_case_out_record")
@Builder
public class NetworkCaseOutRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("case_out_no")
    @ApiModelProperty("提现单号")
    private Long caseOutNo;

    @TableField("driver_user_no")
    @ApiModelProperty("司机编码")
    private Long driverUserNo;

    @TableField("driver_user_name")
    @ApiModelProperty("司机名称")
    private String driverUserName;

    @TableField("mobile")
    @ApiModelProperty("联系电话")
    private String mobile;

    @TableField("payee")
    @ApiModelProperty("收款人")
    private String payee;

    @TableField("bank")
    @ApiModelProperty("开户行")
    private String bank;

    @TableField("collection_bank_code")
    @ApiModelProperty("收款银行账户")
    private String collectionBankCode;

    @TableField("status")
    @ApiModelProperty("状态 10：待平台付款 20：已付款")
    private Integer status;

    @TableField("status_msg")
    @ApiModelProperty("状态简介")
    private String statusMsg;

    @TableField("platform")
    @ApiModelProperty("平台")
    private String platform;

    @TableField("order_no")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @TableField("order_goods_no")
    @ApiModelProperty("货单编号")
    private String orderGoodsNo;

    @TableField("child_no")
    @ApiModelProperty("运单编号")
    private String childNo;

    @TableField("alteration_balance")
    @ApiModelProperty("变动金额")
    private BigDecimal alterationBalance;

    @TableField("create_by")
    @ApiModelProperty("操作人")
    private String createBy;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("finish_time")
    @ApiModelProperty("提现完成时间")
    private LocalDateTime finishTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
