/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERSet;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.exception.CertificateNotMatchException;
import cn.com.infosec.jce.exception.DecryptDataException;
import cn.com.infosec.jce.exception.DecryptKeyException;
import cn.com.infosec.jce.exception.EncryptAlgException;
import cn.com.infosec.jce.exception.EncryptDataException;
import cn.com.infosec.jce.exception.EncryptKeyException;
import cn.com.infosec.jce.exception.WriteEnvDataException;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.provider.fastparser.DerUtil;
import cn.com.infosec.jce.provider.fastparser.EncryptedContentInfo;
import cn.com.infosec.jce.provider.fastparser.EnvelopedData;
import cn.com.infosec.jce.provider.fastparser.FastPkcs7;
import cn.com.infosec.jce.provider.fastparser.IssuerAndSerialNumber;
import cn.com.infosec.jce.provider.fastparser.Item;
import cn.com.infosec.jce.provider.fastparser.RecipientInfo;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PKCS7EnvelopedData
implements PKCSObjectIdentifiers {
    public static SecretKey key;
    public static final int TRIPLE_DES_CBC = 1;
    public static final int DES_CBC = 2;
    public static final int RC2_CBC = 3;
    static final int MD5 = 1;
    static final int MD2 = 2;
    static final int SHA1 = 3;
    static final int RSA = 4;
    static final int DSA = 5;
    static final int SHA224 = 6;
    static final int SHA256 = 7;
    static final int SHA384 = 8;
    static final int SHA512 = 9;
    static final int RC4 = 10;
    static final int DES = 11;
    static final int DESEDE = 12;
    static final int RC2 = 13;
    static final int AES = 14;
    public static final int IV_LENGTH = 8;
    private static final String OID_ENVELOPEDDATATYPE = "1.2.840.113549.1.7.3";
    private static final String OID_ENCRYPTCONTENT = "1.2.840.113549.1.7.1";
    private static final String OID_RSA_ECB_PKCS1PADDING = "1.2.840.113549.1.1.1";
    static final String ID_MD5 = "1.2.840.113549.2.5";
    static final String ID_MD2 = "1.2.840.113549.2.2";
    static final String ID_SHA1 = "1.3.14.3.2.26";
    static final String ID_RSA = "1.2.840.113549.1.1.1";
    static final String ID_DSA = "1.2.840.10040.4.1";
    static final String ID_SHA224 = "2.16.840.1.101.3.4.2.4";
    static final String ID_SHA256 = "2.16.840.1.101.3.4.2.1";
    static final String ID_SHA384 = "2.16.840.1.101.3.4.2.2";
    static final String ID_SHA512 = "2.16.840.1.101.3.4.2.3";
    static final String ID_RC4 = "1.2.840.113549.3.4";
    static final String ID_DES = "1.3.14.3.2.7";
    static final String ID_DESEDE = "1.2.840.113549.3.7";
    static final String ID_RC2 = "1.2.840.113549.3.2";
    static final String ID_AES = "2.16.840.1.101.3.4.2";
    static String[] algArray;
    static String[] algArray2;
    static HashMap algmap;
    byte[] bsPKCS7 = null;
    FastPkcs7 fxPKCS7 = new FastPkcs7();

    static {
        algArray = new String[]{"MD5", "MD2", "SHA1", "RSA", "DSA", "SHA224", "SHA256", "SHA384", "SHA512", "RC4", "DES", "DESEDE", "RC2", "AES"};
        algArray2 = new String[]{"MD5", "MD2", "SHA1", "RSA", "DSA", "SHA224", "SHA256", "SHA384", "SHA512", "RC4", "DES", "3DES", "RC2", "AES"};
        algmap = null;
        algmap = new HashMap();
        algmap.put(ID_MD5, "MD5");
        algmap.put(ID_MD2, "MD2");
        algmap.put(ID_SHA1, "SHA1");
        algmap.put("1.2.840.113549.1.1.1", "RSA");
        algmap.put(ID_DSA, "DSA");
        algmap.put(ID_SHA224, "SHA224");
        algmap.put(ID_SHA256, "SHA256");
        algmap.put(ID_SHA384, "SHA384");
        algmap.put(ID_SHA512, "SHA512");
        algmap.put(ID_RC4, "RC4");
        algmap.put(ID_DES, "DES");
        algmap.put(ID_DESEDE, "DESEDE");
        algmap.put(ID_RC2, "RC2");
        algmap.put(ID_AES, "AES");
    }

    public byte[] decrypt(byte[] envelopeddata, Certificate cert, PrivateKey prik, String provider) throws SecurityException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, IOException {
        if (!this.fxPKCS7.pkcs7SignedData(envelopeddata)) {
            throw new SecurityException("can't decode PKCS7EnvlopedData object");
        }
        EnvelopedData ed = this.fxPKCS7.getEnvelopedData();
        if (ed == null) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header" + this.fxPKCS7.getContentType());
        }
        ArrayList riList = ed.getVRecipientInfo();
        RecipientInfo ri = (RecipientInfo)riList.get(0);
        Item item = ri.getIssuerAndSerialNumber();
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(envelopeddata, item);
        item = iasn.getIssuer();
        byte[] bs = new byte[item.length];
        bs = DerUtil.getItemDataAndTag(envelopeddata, item);
        ASN1InputStream in = new ASN1InputStream(bs);
        String issuer = "";
        try {
            DERObject obj = in.readObject();
            ASN1Sequence seq = ASN1Sequence.getInstance(obj);
            X509Name name = new X509Name(seq);
            issuer = name.toString();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sn = iasn.getSerialNumber().getSerialNumber().toString(10);
        String certIssuer = ((X509Certificate)cert).getIssuerDN().toString();
        String certSN = ((X509Certificate)cert).getSerialNumber().toString(10);
        if (!PKCS7EnvelopedData.compereDN(issuer, certIssuer) || !certSN.equals(sn)) {
            throw new CertificateNotMatchException("Certification is not match");
        }
        byte[] encKey = ri.getEncKey();
        EncryptedContentInfo eci = ed.getEncryptedContentInfoObject();
        item = eci.getContentEncryptionAlgorithm();
        bs = new byte[item.length];
        System.arraycopy(envelopeddata, item.offset, bs, 0, bs.length);
        in = new ASN1InputStream(bs);
        String algName = "";
        try {
            AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance(in.readObject());
            String algoid = alg.getObjectId().getId();
            algName = PKCS7EnvelopedData.getAlgName(algoid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        item = eci.getIvParameter();
        bs = DerUtil.getItemDataAndTag(envelopeddata, item);
        IvParameterSpec param = null;
        if (bs.length != 0 && (bs[0] != 5 || bs[1] != 0)) {
            byte[] tmp = new byte[0xFF & bs[1]];
            System.arraycopy(bs, 2, tmp, 0, tmp.length);
            param = new IvParameterSpec(tmp);
        }
        item = eci.getEncryptedContent();
        byte[] encdata = new byte[item.length];
        System.arraycopy(envelopeddata, item.offset, encdata, 0, encdata.length);
        byte[] key = null;
        try {
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
            c.init(2, prik);
            key = c.doFinal(encKey);
        }
        catch (Exception ex) {
            throw new DecryptKeyException(ex.getMessage());
        }
        byte[] out = null;
        try {
            Cipher cd = Cipher.getInstance(algName, provider);
            SecretKeySpec sk = new SecretKeySpec(key, algName);
            cd.init(2, (Key)sk, param);
            out = cd.doFinal(encdata);
        }
        catch (Exception ex) {
            throw new DecryptDataException(ex.getMessage());
        }
        return out;
    }

    public byte[] decrypt(byte[] envelopeddata, Certificate cert, PrivateKey prik) throws SecurityException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, IOException {
        return this.decrypt(envelopeddata, cert, prik, "INFOSEC");
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, String algStr, String provider, PublicKey pubk) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException {
        int alg = PKCS7EnvelopedData.getAlgID(algStr);
        System.out.println("alg is:" + alg);
        System.out.println("1111111111111111111111111111111111111111111");
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber isAndSN = new cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber(new X509Name(((X509Certificate)cert).getIssuerDN().toString()), new DERInteger(((X509Certificate)cert).getSerialNumber()));
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null);
        System.out.println("222222222222222222222222222222222222222222222");
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(PKCS7EnvelopedData.getAlgName(alg), provider);
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptAlgException("AlgException");
        }
        System.out.println("333333333333333333333333333333333333333333333333");
        SecretKey key = kg.generateKey();
        System.out.println("444444444444444444444444444444444444444444444444");
        byte[] keyData = key.getEncoded();
        System.out.println("5555555555555555555555555555555555555555555555555");
        Cipher c = null;
        byte[] encKey = null;
        try {
            c = Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
            c.init(1, pubk);
            encKey = c.doFinal(keyData);
        }
        catch (Exception ex) {
            throw new EncryptKeyException("enc key exception");
        }
        System.out.println("6666666666666666666666666666666666666666666666666");
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        System.out.println("77777777777777777777777777777777777777777777777777");
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        AlgorithmIdentifier derAlg = PKCS7EnvelopedData.getAlgorithmIdentifier(alg);
        DERObject derParam = (DERObject)derAlg.getParameters();
        IvParameterSpec param = null;
        if (derParam != null) {
            param = new IvParameterSpec(((DEROctetString)derParam).getOctets());
        }
        System.out.println("888888888888888888888888888888888888888888888888888");
        byte[] encdata = null;
        try {
            c = Cipher.getInstance(PKCS7EnvelopedData.getAlgName(alg), provider);
            c.init(1, (Key)key, param);
            encdata = c.doFinal(plaindata);
        }
        catch (Exception ex) {
            throw new EncryptDataException("encrypt data error");
        }
        System.out.println("9999999999999999999999999999999999999999999999999999");
        DERTaggedObject encContent = new DERTaggedObject(true, 0, new DEROctetString(encdata));
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(contentType);
        cont.addObject(derAlg);
        cont.addObject(encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject(version);
        env.addObject(recipientInfos);
        env.addObject(cont);
        String envdatatype = OID_ENVELOPEDDATATYPE;
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject(new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
        p7.addObject(dtCont);
        System.out.println("00000000000000000000000000000000000000000000000000");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(baos);
        try {
            dout.writeObject(p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs;
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, String algStr, String provider) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException {
        int alg = PKCS7EnvelopedData.getAlgID(algStr);
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber isAndSN = new cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber(new X509Name(((X509Certificate)cert).getIssuerDN().toString()), new DERInteger(((X509Certificate)cert).getSerialNumber()));
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null);
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(PKCS7EnvelopedData.getKeyGenAlgName(alg), provider);
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptAlgException("AlgException");
        }
        SecretKey key = kg.generateKey();
        byte[] keyData = key.getEncoded();
        PublicKey pubk = cert.getPublicKey();
        Cipher c = null;
        byte[] encKey = null;
        try {
            c = Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
            c.init(1, pubk);
            encKey = c.doFinal(keyData);
        }
        catch (Exception ex) {
            throw new EncryptKeyException("enc key exception");
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        AlgorithmIdentifier derAlg = PKCS7EnvelopedData.getAlgorithmIdentifier(alg);
        DERObject derParam = (DERObject)derAlg.getParameters();
        IvParameterSpec param = null;
        if (derParam != null) {
            param = new IvParameterSpec(((DEROctetString)derParam).getOctets());
        }
        byte[] encdata = null;
        try {
            c = Cipher.getInstance(PKCS7EnvelopedData.getAlgName(alg), provider);
            c.init(1, (Key)key, param);
            encdata = c.doFinal(plaindata);
        }
        catch (Exception ex) {
            throw new EncryptDataException("encrypt data error");
        }
        DERTaggedObject encContent = new DERTaggedObject(true, 0, new DEROctetString(encdata));
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(contentType);
        cont.addObject(derAlg);
        cont.addObject(encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject(version);
        env.addObject(recipientInfos);
        env.addObject(cont);
        String envdatatype = OID_ENVELOPEDDATATYPE;
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject(new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
        p7.addObject(dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(baos);
        try {
            dout.writeObject(p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs;
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, String algStr) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException {
        return this.encrypt(plaindata, cert, algStr, "INFOSEC");
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, int alg) throws EncryptAlgException, EncryptDataException, EncryptKeyException, WriteEnvDataException {
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber isAndSN = new cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber(new X509Name(((X509Certificate)cert).getIssuerDN().toString()), new DERInteger(((X509Certificate)cert).getSerialNumber()));
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null);
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance(PKCS7EnvelopedData.getKeyGenAlgName(alg), "INFOSEC");
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptAlgException("AlgException");
        }
        SecretKey key = kg.generateKey();
        byte[] keyData = key.getEncoded();
        PublicKey pubk = cert.getPublicKey();
        Cipher c = null;
        byte[] encKey = null;
        try {
            c = Cipher.getInstance("RSA/ECB/PKCS1Padding", "INFOSEC");
            c.init(1, pubk);
            encKey = c.doFinal(keyData);
        }
        catch (Exception ex) {
            throw new EncryptKeyException("enc key exception");
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        AlgorithmIdentifier derAlg = PKCS7EnvelopedData.getAlgorithmIdentifier(alg);
        DERObject derParam = (DERObject)derAlg.getParameters();
        IvParameterSpec param = null;
        if (derParam != null) {
            param = new IvParameterSpec(((DEROctetString)derParam).getOctets());
        }
        byte[] encdata = null;
        try {
            c = Cipher.getInstance(PKCS7EnvelopedData.getAlgName(alg), "INFOSEC");
            c.init(1, (Key)key, param);
            encdata = c.doFinal(plaindata);
        }
        catch (Exception ex) {
            throw new EncryptDataException("encrypt data error");
        }
        DERTaggedObject encContent = new DERTaggedObject(true, 0, new DEROctetString(encdata));
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(contentType);
        cont.addObject(derAlg);
        cont.addObject(encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject(version);
        env.addObject(recipientInfos);
        env.addObject(cont);
        String envdatatype = OID_ENVELOPEDDATATYPE;
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject(new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
        p7.addObject(dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(baos);
        try {
            dout.writeObject(p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs;
    }

    private static AlgorithmIdentifier getAlgorithmIdentifier(int alg) {
        String oid = null;
        boolean hasIV = false;
        if (alg == 10) {
            oid = ID_RC4;
            hasIV = false;
        } else if (alg == 13) {
            oid = ID_RC2;
            hasIV = true;
        } else if (alg == 12) {
            oid = ID_DESEDE;
            hasIV = true;
        } else if (alg == 11) {
            oid = ID_DES;
            hasIV = true;
        } else if (alg == 14) {
            oid = ID_AES;
            hasIV = true;
        }
        DEROctetString sIV = null;
        if (hasIV) {
            byte[] iv = new byte[8];
            SecureRandom ivRandom = new SecureRandom();
            ivRandom.nextBytes(iv);
            sIV = new DEROctetString(iv);
        }
        AlgorithmIdentifier algID = new AlgorithmIdentifier(new DERObjectIdentifier(oid), sIV);
        return algID;
    }

    private static String getKeyGenAlgName(int alg) {
        String name = "";
        if (alg == 10) {
            name = "RC4";
        } else if (alg == 3) {
            name = "RC2";
        } else if (alg == 2) {
            name = "DES";
        } else if (alg == 1) {
            name = "DESEDE";
        }
        return name;
    }

    private static String getAlgName(String oid) {
        String name = null;
        if (algmap.containsKey(oid)) {
            name = algmap.get(oid).toString();
        }
        return name;
    }

    private static String getAlgName(int alg) {
        String name = null;
        name = algArray[alg - 1];
        return name;
    }

    private static int getAlgID(String alg) {
        int id = 0;
        int loop = algArray2.length;
        int i = 0;
        while (i < loop) {
            if (alg.equalsIgnoreCase(algArray2[i])) {
                id = i + 1;
                break;
            }
            ++i;
        }
        return id;
    }

    public static void main(String[] args) {
        Security.addProvider(new InfosecProvider());
        try {
            PKCS7EnvelopedData p7 = new PKCS7EnvelopedData();
            FileInputStream fis = new FileInputStream("d:\\ttt.pfx");
            char[] password = new char[]{'1', '1', '1', '1', '1', '1', '1', '1'};
            KeyStore store = KeyStore.getInstance("PKCS12", "INFOSEC");
            store.load(fis, password);
            Enumeration<String> en = store.aliases();
            String pName = null;
            String pNameCert = null;
            while (en.hasMoreElements()) {
                String n = en.nextElement();
                if (store.isKeyEntry(n)) {
                    pName = n;
                }
                if (!store.isCertificateEntry(n)) continue;
                pNameCert = n;
            }
            fis.close();
            X509Certificate cert = (X509Certificate)store.getCertificate(pName);
            PrivateKey prik = (PrivateKey)store.getKey(pName, "".toCharArray());
            byte[] plainData = "This is a Test".getBytes();
            System.out.println("====================");
            long start = System.currentTimeMillis();
            byte[] env = null;
            int i = 0;
            while (i < 100) {
                env = p7.encrypt(plainData, (Certificate)cert, 10);
                ++i;
            }
            long end = System.currentTimeMillis();
            System.out.println("time=" + (end - start));
            FileOutputStream fos = new FileOutputStream("d:\\testenv.dat");
            fos.write(env);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean compereDN(String DN1, String JKSDN) {
        if (DN1 == null || JKSDN == null) {
            return false;
        }
        if (DN1.equals(JKSDN)) {
            return true;
        }
        String[] temp = JKSDN.split(",");
        String turnDN = temp[0].trim();
        int i = 1;
        while (i <= temp.length - 1) {
            turnDN = String.valueOf(turnDN) + "," + temp[i].trim();
            ++i;
        }
        return DN1.equals(turnDN);
    }
}

