/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.generators;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.AsymmetricCipherKeyPairGenerator;
import cn.com.infosec.crypto.KeyGenerationParameters;
import cn.com.infosec.crypto.generators.DHKeyGeneratorHelper;
import cn.com.infosec.crypto.params.DHKeyGenerationParameters;
import cn.com.infosec.crypto.params.DHParameters;
import cn.com.infosec.crypto.params.DHPrivateKeyParameters;
import cn.com.infosec.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHParameters dhParams = this.param.getParameters();
        BigInteger p = dhParams.getP();
        BigInteger x = this.helper.calculatePrivate(p, this.param.getRandom(), dhParams.getL());
        BigInteger y = this.helper.calculatePublic(p, dhParams.getG(), x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhParams), new DHPrivateKeyParameters(x, dhParams));
    }
}

