package com.clx.performance.struct;

import com.clx.order.vo.feign.FeignAddressVO;
import com.clx.performance.vo.app.Address;
import com.msl.common.utils.DateStructUtil;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.Objects;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {Objects.class})
public interface AddressStruct {

    @Mapping(target = "address", source = "item.addressShorter")
    @Mapping(target = "addressDetail", source = "item.address")
    Address convert(FeignAddressVO.Address item);

    default String addressDetail(FeignAddressVO.Address item){
        return (StringUtils.isBlank(item.getProvince())? "":item.getProvince())
                + (StringUtils.isBlank(item.getCity())? "":item.getCity())
                + (StringUtils.isBlank(item.getCounty())? "":item.getCounty())

                + (StringUtils.isBlank(item.getTown())? "":item.getTown())
                + (StringUtils.isBlank(item.getStreet())? "":item.getStreet())
                + (StringUtils.isBlank(item.getAddress())? "":item.getAddress());
   }
}
