package com.clx.performance.extranal.order.impl;

import com.clx.order.feign.InternalReportFeign;
import com.clx.performance.extranal.order.InternalReportService;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class InternalReportServiceImpl implements InternalReportService {

    @Autowired
    private InternalReportFeign internalReportFeign;

    @Override
    public Boolean checkLineJam(Integer sendSystemAddressId,
                                Integer receiveSystemAddressId,
                                Integer sendAddressId,
                                Integer receiveAddressId,
                                String beginTime,
                                Integer duration) {
        return Optional.of(internalReportFeign.checkLineJam(sendSystemAddressId,
                        receiveSystemAddressId,
                        sendAddressId,
                        receiveAddressId,
                        beginTime,duration))
                .filter(Result::succeed)
                .map(Result::getData)
                .orElse(false);
    }
    @Override
    public Boolean checkLineAbnormal(Integer sendSystemAddressId,
                                               Integer receiveSystemAddressId,
                                               Integer sendAddressId,
                                               Integer receiveAddressId,
                                               String beginTime) {
        return Optional.of(internalReportFeign.checkLineAbnormal(sendSystemAddressId,
                        receiveSystemAddressId,
                        sendAddressId,
                        receiveAddressId,
                        beginTime))
                .filter(Result::succeed)
                .map(Result::getData)
                .orElse(false);
    }

}
