package com.clx.performance.service.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.model.settle.NetworkDriverAccount;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.param.app.NetworkDriverPageParam;
import com.clx.performance.param.pc.PageNetworkAccountInfoListParam;
import com.clx.performance.vo.app.APPNetworkDriverRunningWaterRecordVO;
import com.clx.performance.vo.pc.NetworkDriverRunningWaterRecordVO;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
public interface NetworkDriverRunningWaterRecordService {

    IPage<NetworkDriverRunningWaterRecordVO> networkDriverRunningWaterRecordList(PageNetworkAccountInfoListParam param);

    void generateSettlementRunningWaterRecord(Long userNo, BigDecimal money);

    void generateCaseOutFrozenRunningWaterRecord(Long userNo, BigDecimal money);

    void generateCaseOutSuccessRunningWaterRecord(Long userNo, BigDecimal money);

    void generateNetworkDriverRunningWaterRecord(Long userNo, BigDecimal money, Integer runningWaterType);

    IPage<APPNetworkDriverRunningWaterRecordVO> pageFrozenList(NetworkDriverPageParam param);

    IPage<APPNetworkDriverRunningWaterRecordVO> runningWaterList(NetworkDriverPageParam param);

    void generateNetworkCaseOutRecord(SettlementDriverDetail settlementDriverDetail);
}
