package com.clx.performance.service.impl.settle;


import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.component.IdGenerateSnowFlake;
import com.clx.performance.dao.settle.NetworkDriverAccountDao;
import com.clx.performance.model.settle.NetworkDriverAccount;
import com.clx.performance.param.pc.PageNetworkAccountListParam;
import com.clx.performance.param.pc.driver.NetworkDriverAccountParam;
import com.clx.performance.service.settle.NetworkDriverAccountService;
import com.clx.performance.vo.pc.NetworkDriverAccountVO;
import com.clx.user.feign.PaymentServiceFeign;
import com.clx.user.vo.feign.WalletResidueCardVO;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Service
@AllArgsConstructor
@Slf4j
public class NetworkDriverAccountServiceImpl implements NetworkDriverAccountService {

    private final NetworkDriverAccountDao networkDriverAccountDao;

    private final IdGenerateSnowFlake idGenerateSnowFlake;

    private final PaymentServiceFeign paymentServiceFeign;

    @Override
    public IPage<NetworkDriverAccountVO> networkAccountList(PageNetworkAccountListParam param) {
        return networkDriverAccountDao.networkAccountList(param);
    }

    @Override
    public void createNetworkDriverAccount(NetworkDriverAccountParam param) {
        Optional<NetworkDriverAccount> optional = networkDriverAccountDao.getOneByField(NetworkDriverAccount::getDriverUserNo, param.getDriverUserNo());
        if (optional.isPresent()) {
            log.info("当前用户已经存在,相关参数:{}", JSONUtil.parse(param));
            return;
        }

        String walletCode = idGenerateSnowFlake.nextIdToString(1L);
        NetworkDriverAccount entity = NetworkDriverAccount.builder().driverUserNo(param.getDriverUserNo())
                .mobile(param.getMobile())
                .driverUserName(param.getDriverUserName())
                .accountBalance(BigDecimal.ZERO)
                .usableBalance(BigDecimal.ZERO)
                .frozenBalance(BigDecimal.ZERO)
                .createBy("系统")
                .walletCode(walletCode).build();
        networkDriverAccountDao.saveEntity(entity);
    }

    @Override
    public WalletResidueCardVO account(Integer userCode) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();

        Result<WalletResidueCardVO> result = paymentServiceFeign.getWallet(userCode);
        WalletResidueCardVO data = result.getData();
        NetworkDriverAccount account = networkDriverAccountDao.getOneByField(NetworkDriverAccount::getDriverUserNo, loginUserInfo.getUserNo()).get();

        data.setAssetSum(data.getAssetSum().add(account.getAccountBalance().movePointLeft(2)));
        data.setFrozen(new BigDecimal(data.getFrozen()).add(account.getFrozenBalance().movePointLeft(2)).longValue());
        data.setResidue(new BigDecimal(data.getResidue()).add(account.getUsableBalance().movePointLeft(2)).longValue());

        return data;
    }
}
