package com.clx.performance.service.impl.payment;

import com.clx.performance.config.MslPaymentConfig;
import com.clx.performance.enums.PayRemarkEnum;
import com.clx.performance.extranal.user.DriverService;
import com.clx.performance.param.pc.payment.PayParam;
import com.clx.performance.service.PaymentService;
import com.clx.performance.service.payment.PayService;
import com.clx.user.vo.feign.DriverInfoFeignVo;
import com.msl.common.enums.ResultCodeEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class PayServiceImpl implements PayService {

    @Autowired
    private DriverService driverService;
    @Autowired
    private PaymentService paymentService;

    @Autowired
    private MslPaymentConfig mslPaymentConfig;

    /**
     * 司机支付平台
     */
    @Override
    public void driverPay(String settlementNo, Long driverUserNo, Integer figure) {
        DriverInfoFeignVo driverInfoFeignVo = driverService.getDriverInfo(driverUserNo).orElseThrow(ResultCodeEnum.FAIL);

        pay(driverInfoFeignVo.getWalletCode(), mslPaymentConfig.getTransportWalletCode(), figure, settlementNo, PayRemarkEnum.toString(PayRemarkEnum.DRIVER_PAY_OWNER_DRIVER_INSURANCE.getValue()));

    }

    /**
     * 平台支付司机
     */
    @Override
    public void payDriver(String settlementNo, Long driverUserNo, Integer figure) {
        DriverInfoFeignVo driverInfoFeignVo = driverService.getDriverInfo(driverUserNo).orElseThrow(ResultCodeEnum.FAIL);

        pay(mslPaymentConfig.getTransportWalletCode(), driverInfoFeignVo.getWalletCode(), figure, settlementNo, PayRemarkEnum.toString(PayRemarkEnum.OWNER_PAY_DRIVER_INSURANCE.getValue()));
    }

    /**
     * 支付
     */
    private void pay(Integer walletCodeFrom, Integer walletCodeTo, Integer figure, String tradeNo, String remark){
        PayParam noCheckPwd = PayParam.builder()
                .from(walletCodeFrom)
                .to(walletCodeTo)
                .figure(figure)
                .tradeNo(tradeNo)
                .tradeId(tradeNo)
                .pwd("noCheckPwd")
                .remark(remark)
                .build();
        paymentService.paymentBreakContractWallet(noCheckPwd);
    }

}
