package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Data
@Accessors(chain = true)
@TableName("network_driver_account")
@Builder
public class NetworkDriverAccount implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("driver_user_no")
    @ApiModelProperty("司机编码")
    private Long driverUserNo;

    @TableField("driver_user_name")
    @ApiModelProperty("司机名称")
    private String driverUserName;

    @TableField("mobile")
    @ApiModelProperty("联系电话")
    private String mobile;

    @TableField("account_balance")
    @ApiModelProperty("账户余额")
    private BigDecimal accountBalance;

    @TableField("usable_balance")
    @ApiModelProperty("可用余额")
    private BigDecimal usableBalance;

    @TableField("frozen_balance")
    @ApiModelProperty("冻结余额")
    private BigDecimal frozenBalance;

    @TableField("wallet_code")
    @ApiModelProperty("钱包code")
    private String walletCode;

    @TableField("create_by")
    @ApiModelProperty("创建人")
    private String createBy;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
