package com.clx.performance.model.collect;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 车辆信息上报
* @Date: 2023/11/07 11:11:41
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class CollectTruck implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Long userNo;                            //用户编号
    private String name;                            //用户姓名
    private String mobile;                          //手机号码
    private Integer truckId;                        //车辆id
    private String truckNo;                         //车牌
    private Integer unloadType;                     //卸车类型：1自卸侧翻 2自卸立翻 3非自卸
    private Integer autoLoanStatus;                 //车贷状态：0无车贷 1有车贷
    private Integer autoLoanMonth;                  //车贷剩余月份
    private String parkAddress;                     //车辆停放位置
    private Integer overTonnageType;                 //拉运方式：1标吨 2超吨 3白天标吨晚上超吨
    private Integer distanceUsualPlaceMax;          //接受距常驻地最远距离（公里）
    private Integer distanceLineMax;                //单次任务接受最远距离（公里）
    private Integer distanceSendAddressMax;         //接受距货源地最远距离（公里）
    private String goodsType;                       //拉运货物意愿：1块煤 2面煤 3煤泥
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间


    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}