package com.clx.performance.model.breakcontract;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("break_contract_settlement_owner")
public class BreakContractSettlementOwner  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("break_contract_party_type")
    @ApiModelProperty("违约方类型：1平台 2货主 3车主")
    private Integer breakContractPartyType;

    @TableField("settlement_no")
    @ApiModelProperty("结算单编号")
    private String settlementNo;

    @TableField("owner_user_no")
    @ApiModelProperty("货主用户编号")
    private Long ownerUserNo;

    @TableField("owner_name")
    @ApiModelProperty("货主名称")
    private String ownerName;

    @TableField("order_no")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @TableField("figure")
    @ApiModelProperty("违约金（分）")
    private BigDecimal figure;

    @TableField("invoice_img")
    @ApiModelProperty("结算凭证")
    private String invoiceImg;

    @TableField("payee")
    @ApiModelProperty("收款人")
    private String payee;

    @TableField("payee_bank_name")
    @ApiModelProperty("收款银行")
    private String payeeBankName;

    @TableField("payee_bank_card_no")
    @ApiModelProperty("收款银行卡卡号")
    private String payeeBankCardNo;

    @TableField("payment_img")
    @ApiModelProperty("付款凭证")
    private String paymentImg;

    @TableField("payment_bank_name")
    @ApiModelProperty("付款银行")
    private String paymentBankName;

    @TableField("payment_bank_card_no")
    @ApiModelProperty("付款银行卡卡号")
    private String paymentBankCardNo;

    @TableField("status")
    @ApiModelProperty("状态")
    private Integer status;

    @TableField("break_contract_remark")
    @ApiModelProperty("违约说明")
    private String breakContractRemark;

    @TableField("create_by")
    @ApiModelProperty("操作人编号")
    private Long createBy;

    @TableField("create_name")
    @ApiModelProperty("操作人名称")
    private String createName;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
