package com.clx.performance.model.breakcontract;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("break_contract_settlement_log")
public class BreakContractSettlementLog  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("settlement_no")
    @ApiModelProperty("结算单编号")
    private String settlementNo;

    @TableField("type")
    @ApiModelProperty("类型")
    private Integer type;

    @TableField("remark")
    @ApiModelProperty("内容")
    private String remark;

    @TableField("create_type")
    @ApiModelProperty("操作人类型1-货主， 2-承运端，3-司机")
    private Integer createType;

    @TableField("create_by")
    @ApiModelProperty("操作人编号")
    private Long createBy;

    @TableField("create_name")
    @ApiModelProperty("操作人名称")
    private String createName;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
