package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

@Getter
@Setter
@Accessors(chain = true)
@TableName("third_part_request_log")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ThirdPartRequestLog implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    @ApiModelProperty(value = "ID")
    private Integer id;

    @ApiModelProperty(value = "请求id")
    private String requestId;

    @ApiModelProperty(value = "应用编号")
    private Long appNo;

    @ApiModelProperty(value = "请求类型: 1-发送请求；2-接收请求")
    private Integer requestType;

    @ApiModelProperty(value = "操作类型")
    private String action;

    @ApiModelProperty(value = "请求地址")
    private String url;

    @ApiModelProperty(value = "请求参数（JSON格式）")
    private String requestContent;

    @ApiModelProperty(value = "返回数据（JSON格式）")
    private String responseContent;

    @ApiModelProperty(value = "返回状态码")
    private Integer statusCode;

    @ApiModelProperty(value = "状态: 0-请求中,1-成功,2-失败")
    private Integer status;

    @ApiModelProperty(value = "重试次数")
    private Integer retryTimes;

    @ApiModelProperty(value = "其他字段")
    private String otherFields;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "修改时间")
    private LocalDateTime modifiedTime;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}
