package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 货主流水记录;
 *
 * @date : 2023-10-12
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_running_water_record")
public class OwnerRunningWaterRecord implements HasKey<Integer> {
    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 流水号
     */
    @TableField("running_water_no")
    private Long runningWaterNo;
    /**
     * 货主编码
     */
    @TableField("owner_user_no")
    private Long ownerUserNo;
    /**
     * 货主名称
     */
    @TableField("owner_user_name")
    private String ownerUserName;
    /**
     * 联系电话
     */
    @TableField("mobile")
    private String mobile;
    /**
     * 账户类型
     */
    @TableField("account_type")
    private Integer accountType;

    /**
     * 关联数据编号
     */
    @TableField("relation_id")
    private Long relationId;
    /**
     * 流水类型 10：充值 20：冻结 30：解冻 40：提现冻结 50：提现成功 60：扣除 70：提现失败
     */
    @TableField("running_water_type")
    private Integer runningWaterType;
    /**
     * 订单ID
     */
    @TableField("order_id")
    private Integer orderId;
    /**
     * 订单编号
     */
    @TableField("order_no")
    private String orderNo;
    /**
     * 运单ID
     */
    @TableField("order_child_id")
    private Integer orderChildId;
    /**
     * 运单编号
     */
    @TableField("order_child_no")
    private String orderChildNo;
    /**
     * 变动金额
     */
    @TableField("alteration_balance")
    private BigDecimal alterationBalance;
    /**
     * 冻结金额
     */
    @TableField("frozen_balance")
    private BigDecimal frozenBalance;
    /**
     * 可用余额
     */
    @TableField("usable_balance")
    private BigDecimal usableBalance;
    /**
     * 账户余额
     */
    @TableField("account_balance")
    private BigDecimal accountBalance;

    /**
     * 扣除金额
     */
    @TableField("take_out_balance")
    private BigDecimal takeOutBalance;
    /**
     * 操作人
     */
    @TableField("create_by")
    private String createBy;
    /**
     * 操作时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}