package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_goods_driver_truck")
public class OrderGoodsDriverTruck implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("truck_id")
    @ApiModelProperty("车辆ID")
    private Integer truckId;

    @TableField("truck_no")
    @ApiModelProperty("车牌号")
    private String truckNo;

    @TableField("driver_user_no")
    @ApiModelProperty("司机用户编号")
    private Long driverUserNo;

    @TableField("driver_name")
    @ApiModelProperty(value = "司机名称")
    private String driverName;

    @TableField("driver_mobile")
    @ApiModelProperty("司机手机号")
    private String driverMobile;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;


    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
