package com.clx.performance.extranal.transport.impl;

import com.clx.performance.extranal.transport.TransportService;
import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.param.feign.transport.OwnerLegalSyncParam;
import com.clx.performance.param.feign.transport.OwnerPersonalSyncParam;
import com.clx.performance.param.feign.transport.ThirdOrderChildBrokerParam;
import com.clx.performance.vo.feign.transport.ThirdOrderChildBrokerResultVO;
import com.msl.common.base.Optional;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class TransportServiceImpl implements TransportService {

    @Autowired
    private TransportFeignService transportFeignService;


    @Override
    public ThirdOrderChildBrokerResultVO orderChildSync(ThirdOrderChildBrokerParam param) {
//        return Optional.ofNullable(transportFeignService.orderChildSync(param))
//                .filter(Result::succeed).orElseThrow(ResultCodeEnum.FAIL).getData();
        return null;
    }

    @Override
    public Integer ownerLegalSync(OwnerLegalSyncParam param) {
        return Optional.ofNullable(transportFeignService.ownerLegalSync(param))
                .filter(Result::succeed).orElseThrow(ResultCodeEnum.FAIL).getData();

    }

    @Override
    public Integer ownerPersonalSync(OwnerPersonalSyncParam param) {
        return Optional.ofNullable(transportFeignService.ownerPersonalSync(param))
                .filter(Result::succeed).orElseThrow(ResultCodeEnum.FAIL).getData();

    }

    @Override
    public boolean ownerExistCheck(String mobile) {
        return Optional.ofNullable(transportFeignService.ownerExistCheck(mobile))
                .filter(Result::succeed).orElseThrow(ResultCodeEnum.FAIL).getData() == 1;

    }

    @Override
    public Integer getOwnerId(String mobile) {
        return Optional.ofNullable(transportFeignService.getOwnerId(mobile))
                .filter(Result::succeed).orElseThrow(ResultCodeEnum.FAIL).getData();

    }

}
