package com.clx.performance.extranal.order.impl;

import com.clx.order.feign.OrderFeign;
import com.clx.order.vo.pc.owner.OwnerQuotationDetailVO;
import com.clx.performance.extranal.order.QuotationService;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@Slf4j
@AllArgsConstructor
public class QuotationServiceImpl implements QuotationService {
    private final OrderFeign orderFeign;


    @Override
    public Optional<OwnerQuotationDetailVO> getQuotationByOrderNo(String orderNo) {
        return Optional.ofNullable(orderFeign.getQuotationByOrderNo(orderNo))
                .filter(Result::succeed)
                .map(Result::getData);
    }
}
