package com.clx.performance.extranal.document.impl;

import com.clx.performance.extranal.document.DocumentService;
import com.msl.common.base.Optional;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.result.Result;
import com.msl.document.api.feign.ContractEvidenceFeign;
import com.msl.document.api.feign.ContractTemplateFeign;
import com.msl.document.api.param.GenerateContractParam;
import com.msl.document.api.vo.ContractEvidenceRecordVo;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Map;

@Slf4j
@Service
@AllArgsConstructor
public class DocumentServiceImpl implements DocumentService {

    private final ContractTemplateFeign contractTemplateFeign;
    private final ContractEvidenceFeign contractEvidenceFeign;

    @Override
    public Long createContract(Long templateNo, Map<String, String> map) {
        GenerateContractParam param = new GenerateContractParam();
        param.setTemplateNo(templateNo);
        param.setParametersValueMap(map);

        return Optional.ofNullable(contractTemplateFeign.generateContract(param))
                .filter(Result::succeed).map(item->item.getData()).orElseThrow(ResultCodeEnum.FAIL);

    }

    @Override
    public ContractEvidenceRecordVo getContractInfo(Long evidenceNo) {

        return Optional.ofNullable(contractEvidenceFeign.getContractEvidenceDetail(evidenceNo))
                .filter(Result::succeed).map(item->item.getData()).orElseThrow(ResultCodeEnum.FAIL);
    }

}
