package com.clx.performance.dao.impl.settle;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.NetworkDriverAccountDao;
import com.clx.performance.mapper.settle.NetworkDriverAccountMapper;
import com.clx.performance.model.settle.NetworkDriverAccount;
import com.clx.performance.param.pc.PageNetworkAccountListParam;
import com.clx.performance.vo.pc.NetworkDriverAccountVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import com.msl.common.utils.DateUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Repository
public class NetworkDriverAccountDaoImpl extends BaseDaoImpl<NetworkDriverAccountMapper, NetworkDriverAccount, Integer> implements NetworkDriverAccountDao {

    @Override
    public IPage<NetworkDriverAccountVO> networkAccountList(PageNetworkAccountListParam param) {
        Page<NetworkDriverAccountVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.networkAccountList(page, param);
    }

    public Integer updateAccountCAS(NetworkDriverAccount account, LocalDateTime now, boolean flag) {
        String nowStr = DateUtils.formatDateTime(now).get();
        if (flag) {
            return baseMapper.addAccount(account, nowStr);
        } else {
            return baseMapper.subAccount(account, nowStr);
        }
    }
}
