package com.clx.performance.dao.impl.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.collect.CollectTruckWaitDao;
import com.clx.performance.mapper.collect.CollectTruckWaitMapper;
import com.clx.performance.model.collect.CollectTruckWait;
import com.clx.performance.param.app.collect.PageCollectTruckWaitParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckWaitParam;
import com.clx.performance.vo.pc.collect.CollectTruckWaitVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @Author: aiqinguo
 * @Description: 线路排队耗时
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class CollectTruckWaitDaoImpl extends BaseDaoImpl<CollectTruckWaitMapper, CollectTruckWait, Integer> implements CollectTruckWaitDao {

    @Override
    public boolean updateAuditStatus(CollectTruckWait item) {
        return update(lUdWrapper()
                .eq(CollectTruckWait::getId, item.getId())
                .set(CollectTruckWait::getAuditStatus, item.getAuditStatus())
        );
    }

    @Override
    public IPage<CollectTruckWaitVO> pageWaitReport(PageCollectTruckWaitParam param) {
        Page<CollectTruckWaitVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageWaitReport(page,param);
    }

    @Override
    public IPage<CollectTruckWaitVO> carrierPageWaitReport(CarrierPageCollectTruckWaitParam param) {
        Page<CollectTruckWaitVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.carrierPageWaitReport(page,param);
    }
}
