package com.clx.performance.dao.impl.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.collect.CollectTruckRefuelDao;
import com.clx.performance.mapper.collect.CollectTruckRefuelMapper;
import com.clx.performance.model.collect.CollectTruckRefuel;
import com.clx.performance.param.app.collect.PageCollectTruckRefuelParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckRefuelParam;
import com.clx.performance.vo.pc.collect.CollectTruckRefuelVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @Author: aiqinguo
 * @Description: 油表上报信息
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class CollectTruckRefuelDaoImpl extends BaseDaoImpl<CollectTruckRefuelMapper, CollectTruckRefuel, Integer> implements CollectTruckRefuelDao {

    @Override
    public IPage<CollectTruckRefuelVO> pageRefuel(PageCollectTruckRefuelParam param) {
        Page<CollectTruckRefuelVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageRefuel(page,param);
    }

    @Override
    public IPage<CollectTruckRefuelVO> carrierPageRefuel(CarrierPageCollectTruckRefuelParam param) {
        Page<CollectTruckRefuelVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.carrierPageRefuel(page,param);
    }
}
