package com.clx.performance.dao.impl.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.collect.CollectTruckLeaveDao;
import com.clx.performance.mapper.collect.CollectTruckLeaveMapper;
import com.clx.performance.model.collect.CollectTruckLeave;
import com.clx.performance.param.app.collect.PageCollectTruckLeaveParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLeaveParam;
import com.clx.performance.vo.pc.collect.CollectTruckLeaveVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @Author: aiqinguo
 * @Description: 司机请假表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class CollectTruckLeaveDaoImpl extends BaseDaoImpl<CollectTruckLeaveMapper, CollectTruckLeave, Integer> implements CollectTruckLeaveDao {

    @Override
    public IPage<CollectTruckLeaveVO> pageLeave(PageCollectTruckLeaveParam param) {
        Page<CollectTruckLeaveVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageLeave(page,param);
    }

    @Override
    public IPage<CollectTruckLeaveVO> carrierPageLeave(CarrierPageCollectTruckLeaveParam param) {
        Page<CollectTruckLeaveVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.carrierPageLeave(page,param);
    }
}
