package com.clx.performance.dao.impl.collect;

import com.clx.performance.dao.collect.CollectTruckDao;
import com.clx.performance.enums.OrderGoodsTruckBindEnum;
import com.clx.performance.mapper.collect.CollectTruckMapper;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.clx.performance.model.collect.CollectTruck;
import com.clx.performance.param.app.collect.CollectTruckParam;
import com.clx.performance.vo.app.collect.AppCollectTruckVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 车辆信息上报
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class CollectTruckDaoImpl extends BaseDaoImpl<CollectTruckMapper, CollectTruck, Integer> implements CollectTruckDao {

    @Override
    public boolean update(CollectTruck item) {
        return update(lUdWrapper()
                .eq(CollectTruck::getId, item.getId())
                .set(CollectTruck::getUnloadType, item.getUnloadType())
                .set(CollectTruck::getAutoLoanStatus, item.getAutoLoanStatus())
                .set(CollectTruck::getAutoLoanMonth, item.getAutoLoanMonth())
                .set(CollectTruck::getParkAddress, item.getParkAddress())
                .set(CollectTruck::getOverTonnageType, item.getOverTonnageType())
                .set(CollectTruck::getDistanceUsualPlaceMax, item.getDistanceUsualPlaceMax())
                .set(CollectTruck::getDistanceLineMax, item.getDistanceLineMax())
                .set(CollectTruck::getDistanceSendAddressMax, item.getDistanceSendAddressMax())
                .set(CollectTruck::getGoodsType, item.getGoodsType())

        );
    }

    @Override
    public Optional<CollectTruck> getByUserNoAndTruckNo(Long userNo, String truckNo) {
        return Optional.of(truckNo)
                .map(item -> lQrWrapper()
                        .eq(CollectTruck::getTruckNo, truckNo)
                        .eq(CollectTruck::getUserNo, userNo)
                )
                .map(super::getOne);
    }

    @Override
    public List<CollectTruck> listCollectTruck(List<String> truckNos) {
        return baseMapper.selectList(lQrWrapper().in(CollectTruck::getTruckNo,truckNos));
    }
}
