package com.clx.performance.controller.feign;

import com.clx.performance.param.pc.OrderChildReportParam;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.vo.feign.FreightEstimateVO;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@RestController
@RequestMapping("/feign/orderGoods")
@Validated
@Api(tags = "货单Feign")
@AllArgsConstructor
public class OrderGoodsFeignController {

    private final OrderGoodsService orderGoodsService;

    @GetMapping({"/getOrderGoodsListByOrderNo"})
    List<OrderGoodsFeignVO> getOrderGoodsListByOrderNo(@RequestParam("userNo") @NotNull(message = "订单编号不可为空") String orderNo) {
        return orderGoodsService.getOrderGoodsListByOrderNo(orderNo);
    }

    @GetMapping({"/updateOrderGoodsStopFlag"})
    Result<Boolean> updateOrderGoodsStopFlag(@RequestParam("orderNo") @NotBlank(message = "订单编号不可为空") String orderNo,
                                             @RequestParam("stopFlag") @NotNull(message = "暂停标志不可为空") Integer stopFlag) {
        return Result.ok(orderGoodsService.updateOrderGoodsStopFlag(orderNo,stopFlag));
    }

    @GetMapping({"/updateSystemAddressId"})
    Result<Boolean> updateSystemAddressId(@RequestParam("ownerAddressId") @NotNull(message = "货主地址id不能为空") Integer ownerAddressId,
                                             @RequestParam("systemAddressId") @NotNull(message = "系统地址id不能为空") Integer systemAddressId) {
        return Result.ok(orderGoodsService.updateSystemAddressId(ownerAddressId,systemAddressId));
    }


    @PostMapping({"/listFreightEstimate"})
    Result<FreightEstimateVO> listFreightEstimate(@RequestBody OrderChildReportParam param) {
        return Result.ok(orderGoodsService.listFreightEstimate(param));
    }

}
