package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.CollectWaitReportReceiveAddressSaveParam;
import com.clx.performance.param.app.collect.CollectWaitReportSendAddressSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckWaitParam;
import com.clx.performance.service.collect.CollectWaitReportService;
import com.clx.performance.vo.pc.collect.CollectTruckWaitVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/app/driver/collect/wait")
@Validated
@Api(tags = "APP-排队上报")
@AllArgsConstructor
public class AppDriverCollectTruckWaitController {

    private final CollectWaitReportService collectWaitReportService;

    @ApiOperation(value = "上报装货地排队情况", notes = "<br>By:艾庆国")
    @PostMapping("/saveSendAddressReport")
    public Result<Void> saveSendAddressReport(@RequestBody @Validated CollectWaitReportSendAddressSaveParam param) {
        collectWaitReportService.saveSendAddressReport(param);

        return Result.ok();
    }

    @ApiOperation(value = "上报卸车地排队情况", notes = "<br>By:艾庆国")
    @PostMapping("/saveReceiveAddressReport")
    public Result<Void> saveReceiveAddressReport(@RequestBody @Validated CollectWaitReportReceiveAddressSaveParam param) {
        collectWaitReportService.saveReceiveAddressReport(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询线路上报详情", notes = "<br>By:艾庆国")
    @GetMapping("/getReportInfo")
    public Result<CollectTruckWaitVO> getReportInfo(Integer id) {

        return Result.ok(collectWaitReportService.getReportInfo(id));
    }

    @ApiOperation(value = "分页查询排队上报列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageWaitReport")
    @UnitCovert(param = false)
    public Result<PageData<CollectTruckWaitVO>> pageWaitReport(@RequestBody @Validated PageCollectTruckWaitParam param) {
        IPage<CollectTruckWaitVO> page = collectWaitReportService.pageWaitReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
