package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.NetworkDriverPageParam;
import com.clx.performance.service.settle.NetworkDriverAccountService;
import com.clx.performance.service.settle.NetworkDriverRunningWaterRecordService;
import com.clx.performance.vo.app.APPNetworkDriverRunningWaterRecordVO;
import com.clx.user.vo.feign.WalletResidueCardVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping("/app/driver")
@Validated
@AllArgsConstructor
@Api(tags = "APP-司机资金管理")
public class AppDriverAccountController {

    private final NetworkDriverAccountService networkDriverAccountService;

    private final NetworkDriverRunningWaterRecordService networkDriverRunningWaterRecordService;


    @ApiOperation(value = "APP司机账户", notes = "<br>By:胡宇帆")
    @GetMapping("/account")
    @UnitCovert(param = false)
    public Result<WalletResidueCardVO> account(@RequestParam(value = "userCode") Integer userCode) {
        WalletResidueCardVO walletResidueCardVO = networkDriverAccountService.account(userCode);
        return Result.ok(walletResidueCardVO);
    }

    @ApiOperation(value = "APP司机账户冻结明细", notes = "<br>By:胡宇帆")
    @PostMapping("/frozenList")
    @UnitCovert(param = false)
    public Result<PageData<APPNetworkDriverRunningWaterRecordVO>> frozenList(@RequestBody NetworkDriverPageParam param) {
        IPage<APPNetworkDriverRunningWaterRecordVO> page = networkDriverRunningWaterRecordService.pageFrozenList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "APP司机账户流水明细", notes = "<br>By:胡宇帆")
    @PostMapping("/runningWaterList")
    @UnitCovert(param = false)
    public Result<PageData<APPNetworkDriverRunningWaterRecordVO>> runningWaterList(@RequestBody NetworkDriverPageParam param) {
        IPage<APPNetworkDriverRunningWaterRecordVO> page = networkDriverRunningWaterRecordService.runningWaterList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }
}
