package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeySettlementConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 司机积分 MQ
 * @Date: 2023-10-12 16:27:30
 * @Version: 1.0
 */
@Configuration
public class RabbitSettlementConfig {

    @Bean
    public DirectExchange settlementDefaultExchange() {
        return new DirectExchange(RabbitKeySettlementConstants.DEFAULT_EXCHANGE);
    }

    @Bean
    public Queue settlementDefaultDelayQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-message-ttl", 15 * 60 * 1000);
        params.put("x-max-length", 5000000);
        params.put("x-dead-letter-exchange", RabbitKeySettlementConstants.DEFAULT_EXCHANGE);
        params.put("x-dead-letter-routing-key", RabbitKeySettlementConstants.DEFAULT_DEAD_ROUTING_KEY);
        return new Queue(RabbitKeySettlementConstants.DEFAULT_DELAY_QUEUE, true, false, false, params);
    }
    @Bean
    public Binding settlementDefaultDelayQueueBinding() {
        return BindingBuilder.bind(settlementDefaultDelayQueue()).to(settlementDefaultExchange()).with(RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY);
    }

    @Bean
    public Queue settlementDefaultDeadQueue() {
        return new Queue(RabbitKeySettlementConstants.DEFAULT_DEAD_QUEUE);
    }
    @Bean
    public Binding settlementDefaultDeadQueueBinding() {
        return BindingBuilder.bind(settlementDefaultDeadQueue()).to(settlementDefaultExchange()).with(RabbitKeySettlementConstants.DEFAULT_DEAD_ROUTING_KEY);
    }


    /**
     * 计费明细新增
     */
    @Bean
    public Queue settlementDetailAddQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_DETAIL_ADD_QUEUE);
    }
    @Bean
    public Binding settlementDetailAddQueueBinding() {
        return BindingBuilder.bind(settlementDetailAddQueue()).to(settlementDefaultExchange()).with(RabbitKeySettlementConstants.SETTLEMENT_DETAIL_ADD_ROUTING_KEY);
    }

    /**
     * 计费明细新增
     */
    @Bean
    public Queue settlementDetailInvoiceTypeSyncQueue() {
        return new Queue(RabbitKeySettlementConstants.SETTLEMENT_DETAIL_INVOICE_TYPE_SYC_QUEUE);
    }
    @Bean
    public Binding settlementDetailInvoiceTypeSyncQueueBinding() {
        return BindingBuilder.bind(settlementDetailInvoiceTypeSyncQueue()).to(settlementDefaultExchange()).with(RabbitKeySettlementConstants.SETTLEMENT_DETAIL_INVOICE_TYPE_SYC_ROUTING_KEY);
    }


}
