package com.clx.performance.vo.pc.collect;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 油表上报信息
* @Date: 2023/10/16 13:06:27
* @Version: 1.0
*/

@ApiModel(description = "油表上报信息")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectTruckRefuelVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "用户编号", example = "")
    private Long userNo;
    @ApiModelProperty(value = "用户姓名", example = "")
    private String name;
    @ApiModelProperty(value = "手机号码", example = "")
    private String mobile;
    @ApiModelProperty(value = "车牌号", example = "")
    private String truckNo;
    @ApiModelProperty(value = "运单编号", example = "")
    private String childNo;
    @ApiModelProperty(value = "发货地址id", example = "")
    private Integer sendAddressId;
    @ApiModelProperty(value = "发货地址", example = "")
    private String sendAddress;
    @ApiModelProperty(value = "收货地址id", example = "")
    private Integer receiveAddressId;
    @ApiModelProperty(value = "收货地址", example = "")
    private String receiveAddress;
    @ApiModelProperty(value = "装车油表", example = "", hidden = true)
    private String loadImage;
    @ApiModelProperty(value = "装车油表list集合", example = "")
    private List<String> loadImageList;
    public List<String> getLoadImageList() {
        return StringUtils.isEmpty(loadImage)? new ArrayList<>() : JSON.parseArray(loadImage, String.class);
    }

    @ApiModelProperty(value = "装车油量", example = "")
    private BigDecimal loadOil;
    @ApiModelProperty(value = "卸车油表集合", example = "", hidden = true)
    private String unloadImage;
    @ApiModelProperty(value = "装车油表list集合", example = "")
    private List<String> unloadImageList;
    public List<String> getUnloadImageList() {
        return StringUtils.isEmpty(unloadImage)? new ArrayList<>() : JSON.parseArray(unloadImage, String.class);
    }

    @ApiModelProperty(value = "卸车油量", example = "")
    private BigDecimal unloadOil;
    @ApiModelProperty(value = "上报时间", example = "")
    private String reportTime;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

}