package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;

/**
 * @ClassName TruckTraceVO
 * @Description
 * @Author kavin
 * @Date 2023/11/13 9:50
 * @Version 1.0
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TruckTraceVO {


    @ApiModelProperty(value = "车牌号",  dataType = "String")
    private String truckNo;
    @ApiModelProperty(value = "正北方向夹角", example = "90",  dataType = "String")
    private BigDecimal angle;
    @ApiModelProperty(value = "GPS 速度", example = "602",  dataType = "String")
    private BigDecimal speed;
    @ApiModelProperty(value = "里程", example = "1500",  dataType = "String")
    private BigDecimal mileage;
    @ApiModelProperty(value = "海拔", example = "3250",  dataType = "String")
    private BigDecimal height;
    @ApiModelProperty(value = "经度", example = "31.1233",  dataType = "BigDecimal")
    private BigDecimal longitude;
    @ApiModelProperty(value = "纬度", example = "161.342543",  dataType = "BigDecimal")
    private BigDecimal latitude;
    @ApiModelProperty(value = "GPS 时间", example = "20140325/104954",  dataType = "String")
    private String gpsTime;
    @ApiModelProperty(value = "创建时间", dataType = "String")
    private String createTime;
    @ApiModelProperty(value = "更新时间",  dataType = "String")
    private String modifiedTime;
}
