package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Getter
@Setter
@Accessors(chain = true)
public class NetworkDriverRunningWaterRecordVO{

    private Integer id;

    @ApiModelProperty("流水号")
    private Long runningWaterNo;

    @ApiModelProperty("司机编码")
    private String driverUserNo;

    @ApiModelProperty("司机名称")
    private String driverUserName;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("流水类型 10：运单结算 20：提现冻结 30：提现成功")
    private Integer runningWaterType;

    @ApiModelProperty("流水类型简介")
    private Integer runningWaterTypeMsg;

    @ApiModelProperty("资金类型 10：收入 20：冻结 30：支出")
    private Integer fundType;

    @ApiModelProperty("资金类型简介")
    private Integer fundTypeMsg;

    @ApiModelProperty("")
    private Long relationId;

    @ApiModelProperty("订单ID")
    private Integer orderId;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("运单ID")
    private Integer orderChildId;

    @ApiModelProperty("运单编号")
    private String orderChildNo;

    @ApiModelProperty("变动金额")
    private BigDecimal alterationBalance;

    @ApiModelProperty("冻结金额")
    private BigDecimal frozenBalance;

    @ApiModelProperty("可用余额")
    private BigDecimal usableBalance;

    @ApiModelProperty("账户余额")
    private BigDecimal accountBalance;

    @ApiModelProperty("扣除金额")
    private BigDecimal takeOutBalance;

    @ApiModelProperty("操作人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("修改时间")
    private String modifiedTime;

}
