package com.clx.performance.util;

public class NumberToChineseUtil {
    private final static String[] CN_NUMBERS = {"零", "一", "二", "三", "四", "五", "六", "七", "八", "九"};
    private final static String[] CN_UNITS = {"", "十", "百", "千", "万"};

    public static String convertToChinese(int number) {
        if (number < 0 || number > 9999) {
            throw new IllegalArgumentException("Invalid number");
        }

        if (number == 0) {
            return CN_NUMBERS[0];
        }

        StringBuilder result = new StringBuilder();
        int unitIndex = 0;

        while (number > 0) {
            int digit = number % 10;
            if (digit != 0) {
                result.insert(0, CN_NUMBERS[digit] + CN_UNITS[unitIndex]);
            }
            unitIndex++;
            number /= 10;
        }

        return result.toString();
    }
}