package com.clx.performance.param.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotNull;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildReportParam {

    @ApiModelProperty(value = "发货地址id 必填")
    @NotNull(message = "发货地址id不能为空")
    private Integer sendAddressId;

    @ApiModelProperty(value = "收货地址id 必填")
    @NotNull(message = "收货地址id不能为空")
    private Integer receiveAddressId;

    @ApiModelProperty(value = "开始时间 必填")
    @NotNull(message = "开始时间")
    private String beginTime;
    @ApiModelProperty(value = "订单编号")
    private String orderNo;
}
