package com.clx.performance.param.pay;

public enum ResultCodeEnum implements ResultEnum {
	SUCCESS(0, "success"),
    FAIL(1, "服务繁忙"),
    THIRDPARTY(2,"调用第三方接口参数错误"),
    HTTPERROR(3,"HTTP请求异常"),
    ILLEGAL_PARAMETER(4, "非法参数"),
    SYSTEM_ERROR(5, "系统异常"),
	REQUEST_TOO_OFTEN(6, "请勿频繁点击"),
	MASSAGE_SERVICE_ERROR(7, "消息服务繁忙"),
	ORDER_COMPLETE(8, "订单已经处理过了"),
	DATA_SYNC_ERROR(9, "数据同步异常"),
	MQ_ERROR(10, "消息队列异常"),
	NO_LOGIN(100, "没有登录"),
	NO_OPERATING_AUTHORIZATION(101, "没有权限"),
	FEGIN_NULL(102, "FEGIN返回null"),
	FEGIN_ERROR(103, "fegin调用繁忙"),
	EVALUATION_INFORMATION_NULL(104, "评价信息不能为空"),
	SUBJECT_TO_BE_EVALUATED_NULL(105, "被评价主体不能为空"),
	EVALUATION_TYPE_ERROR(106, "评价类型错误"),
	EVALUATION_SCORE_ERROR(107, "评价分值错误"),
	LABEL_OR_CONTENT_NULL(108, "差评时必须有标签或者内容"),
	CHILD_NO_NULL(109, "运单号不能为空"),
	REDIS_LOCK_ERROR(110, "锁异常"),

	VERIFICATION_CODE_ERROR(111, "验证码错误"),
	VERIFICATION_CODE_COUNT_ERROR(112, "验证码输入错误次数过多，请重新获取"),

	ACCOUNT_LOCKED_TTL_ERROR(113, "账号已锁定，请%s分钟之后再试"),
	ACCOUNT_PWD_ERROR(114, "密码错误，还可尝试%s次，超过将锁定"),

	PRODUCT_TYPE_ERROR(115, "产品线参数错误"),

	;

	// 成员变量
	private String msg;
	private int code;

	// 构造方法
	private ResultCodeEnum(int code, String msg) {
		this.msg = msg;
		this.code = code;
	}

	// 普通方法
	public static String getMsg(int code) {
		for (ResultCodeEnum c : ResultCodeEnum.values()) {
			if (c.getCode() == code) {
				return c.msg;
			}
		}
		return null;
	}
	
	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}

}
