package com.clx.performance.param.feign.transport;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class ThirdOrderInfoDTO {

    @ApiModelProperty(value = "货单编码", required = true)
    private String orderNo;
    @ApiModelProperty(value = "货物名称", required = true)
    private String goodsName;

    @ApiModelProperty(value = "发货单位")
    private String sendCompany;
    @ApiModelProperty(value = "发货所在省份", required = true)
    @NotBlank(message = "发货所在省份不能为空")
    private String sendProvince;
    @ApiModelProperty(value = "发货所在城市", required = true)
    @NotBlank(message = "发货所在城市不能为空")
    private String sendCity;
    @ApiModelProperty(value = "发货所在区县", required = true)
    @NotBlank(message = "发货所在区县不能为空")
    private String sendCounty;
    @ApiModelProperty(value = "发货所在乡镇", required = true)
//    @NotBlank(message = "发货所在乡镇不能为空")
    private String sendTown;
    @ApiModelProperty(value = "发货详细地址", required = true)
    @NotBlank(message = "发货详细地址不能为空")
    private String sendAddress;
    @ApiModelProperty(value = "发货联系人", required = true)
    @NotBlank(message = "发货联系人不能为空")
    private String sendName;
    @ApiModelProperty(value = "发货联系人手机号", required = true)
    @NotBlank(message = "发货联系人手机号不能为空")
    private String sendMobile;
    @ApiModelProperty(value = "发货地址经度", required = true)
    @NotBlank(message = "发货地址经度不能为空")
    private String loadLongitude;
    @ApiModelProperty(value = "发货地址纬度", required = true)
    @NotBlank(message = "发货地址纬度不能为空")
    private String loadLatitude;

    @ApiModelProperty(value = "收货单位")
    private String receiveCompany;
    @ApiModelProperty(value = "收货人所在省", required = true)
    @NotBlank(message = "收货人所在省不能为空")
    private String receiveProvince;
    @ApiModelProperty(value = "收货人所在城市", required = true)
    @NotBlank(message = "收货人所在城市不能为空")
    private String receiveCity;
    @ApiModelProperty(value = "收货人所在区县", required = true)
    @NotBlank(message = "收货人所在区县不能为空")
    private String receiveCounty;
    @ApiModelProperty(value = "收货人所在乡镇", required = true)
//    @NotBlank(message = "收货人所在乡镇不能为空")
    private String receiveTown;
    @ApiModelProperty(value = "收货详细地址", required = true)
    @NotBlank(message = "收货详细地址不能为空")
    private String receiveAddress;
    @ApiModelProperty(value = "收货联系人", required = true)
    @NotBlank(message = "收货联系人不能为空")
    private String receiveName;
    @ApiModelProperty(value = "收货联系人手机号", required = true)
    @NotBlank(message = "收货联系人手机号不能为空")
    private String receiveMobile;
    @ApiModelProperty(value = "收货地址经度", required = true)
    @NotBlank(message = "收货地址经度不能为空")
    private String unloadLongitude;
    @ApiModelProperty(value = "收货地址纬度", required = true)
    @NotBlank(message = "收货地址纬度不能为空")
    private String unloadLatitude;

    @ApiModelProperty(value = "货物单价（单位：分）", required = true)
    @NotNull(message = "货物单价不能为空")
    private Integer goodsPrice;
    @ApiModelProperty(value = "运费单价（单位：分）", required = true)
    @NotNull(message = "运费单价不能为空")
    private Integer transPrice;
    @ApiModelProperty(value = "货物总重量(吨)", required = true)
    @NotNull(message = "货物总重量不能为空")
    private BigDecimal goodsAmount;
    @ApiModelProperty(value = "最晚装货时间", required = true)
    @NotBlank(message = "最晚装货时间不能为空")
    private String extractTime;
    @ApiModelProperty(value = "司机最晚到达时间", required = true)
    @NotBlank(message = "司机最晚到达时间不能为空")
    private String arriveTime;

}
