package com.clx.performance.param.feign.transport;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildBankInfoDTO {

//    @ApiModelProperty(value = "运单号", dataType="String", required = true)
//    private String childNo;
//    @ApiModelProperty(value = "用户钱包", dataType="Integer", required = true)
//    private Integer userCode;

    @ApiModelProperty(value = "持卡人姓名", dataType="String", required = true)
    private String name;
    @ApiModelProperty(value = "银行卡卡号", dataType="String", required = true)
    private String cardNo;
    @ApiModelProperty(value = "手机号", dataType="String", required = true)
    private String mobile;
    @ApiModelProperty(value = "账户类型 11个人 12企业账户", dataType="Integer", required = true)
    private Integer accountType;
    @ApiModelProperty(value = "银行卡类型10借记卡20借贷卡", dataType="String", required = true)
    private String type;

//    @ApiModelProperty(value = "是否允许提现: 允许提现1 ,禁止提现0", dataType="Integer", required = true)
//    private Integer cashOut;

    @ApiModelProperty(value = "身份证号", dataType="String", required = true)
    @NotBlank(message = "身份证号不能为空")
    private String idCard;
    @ApiModelProperty(value = "银行", dataType="String", required = true)
    @NotBlank(message = "银行不能为空")
    private String bank;
    @ApiModelProperty(value = "银行编码", dataType="String", required = true)
    @NotBlank(message = "银行编码不能为空")
    private String bankCode;

    @ApiModelProperty(value = "身份证正面图片", required = true)
    @NotBlank(message = "身份证正面图片不能为空")
    private String idCardFrontImg;
    @ApiModelProperty(value = "身份证背面图片", required = true)
    @NotBlank(message = "身份证背面图片不能为空")
    private String idCardBackImg;

}
