package com.clx.performance.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildUnloadParam extends PositionParam {

    @ApiModelProperty(value = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @ApiModelProperty(value = "卸货磅单编号", example = "url")
    @NotBlank(message = "交货磅单号不能为空")
    private String unloadPoundNo;

    @ApiModelProperty(value = "卸货毛重（单位吨）", example = "2.46")
    private BigDecimal unloadRough;
    @ApiModelProperty(value = "卸货皮重（单位吨）", example = "1.23")
    private BigDecimal unloadTare;
    @ApiModelProperty(value = "卸货净重（单位吨）", example = "1.23")
    @NotNull(message = "装货净重不能为空")
    @Max(value = 999, message = "最大999吨")
    private BigDecimal unloadNet;

    @ApiModelProperty(value = "磅单图片列表")
    @NotEmpty(message = "请上传磅单照片")
    private List<String> unloadImageList;

}
