package com.clx.performance.enums.collect;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum CollectLineReportEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {
        SEND(1, "发货地"),
        RECEIVE(2, "目的地");
        private final Integer code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    //1:无法到达货源地 2:无法装货 3：无法到达目的地  4：运单取消  5：装车卸车异常  6：没有接单 7：货源地情况 8:其它上报 9：煤炭质量上报
    @Getter
    @AllArgsConstructor
    public enum ReportType {
        UNABLE_TO_SEND_ADDRESS(1, "无法到达货源地"),
        UNABLE_LOAD(2, "无法装货"),
        UNABLE_TO_RECEIVE_ADDRESS(3, "无法到达目的地"),
        LOAD_UNLOAD(4, "装卸车时间过长"),

        NO_TAKE_ORDER(6, "没有接单"),
        SEND_ADDRESS(7, "货源地情况"),

        OTHER(8, "其它上报"),
        QUALITY(9, "煤炭质量上报"),

        ;
        private final Integer code;
        private final String msg;

        public static Optional<ReportType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum ReportStatus {
        NORMAL(1, "正常"),
        ABNORMAL(2, "异常");
        private final Integer code;
        private final String msg;

        public static Optional<ReportStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum CoalStatus {
        NO(1, "否"),
        EXIST(2, "有存煤"),
        PRODUCTION(3, "现产现装");
        private final Integer code;
        private final String msg;

        public static Optional<CoalStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum AuditStatus {
        UNAUDIT(0, "待审核"),
        AUDIT(1, "已审核");
        private final Integer code;
        private final String msg;

        public static Optional<AuditStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }


}
