package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderGoodsStopEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {

        NO(0, "未暂停"),

        YES(1, "已暂停")
        ;

        private final Integer code;
        private final String name;

        public static Optional<Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }


}
