package com.clx.performance.controller.feign;

import com.clx.open.sdk.request.action.BreakContractSettlementGenerateAction;
import com.clx.performance.param.feign.OrderAdjustTonnageDownParam;
import com.clx.performance.service.breakcontract.BreakContractOwnerRecordService;
import com.clx.performance.service.breakcontract.BreakContractOwnerRuleService;
import com.clx.performance.service.breakcontract.BreakContractSettlementOwnerService;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRuleVO;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;


@Slf4j
@RestController
@RequestMapping(value="/feign/breakContract")
@Validated
@Api(tags = "货主违约结算单")
@AllArgsConstructor
public class BreakContractSettlementOwnerFeignController {

    private final BreakContractSettlementOwnerService breakContractSettlementOwnerService;

    private final BreakContractOwnerRuleService breakContractOwnerRuleService;

    private final BreakContractOwnerRecordService breakContractOwnerRecordService;




    @ApiOperation(value = "货主订单吨数下调自动保存违约结算单")
    @PostMapping("/saveSettlementOwnerForTonnageDown")
    Result<Void> saveBreakContractSettlementOwner(@RequestBody @Validated OrderAdjustTonnageDownParam param){
        breakContractSettlementOwnerService.saveSettlementOwnerForTonnageDown(param);
        return Result.ok();
    }

    @ApiOperation(value = "查询货主违约规则")
    @GetMapping("/getRuleInfo")
    Result<BreakContractOwnerRuleVO> getRuleInfo(@RequestParam Integer id){
        return Result.ok(breakContractOwnerRuleService.getRuleInfo(id));
    }

    @ApiOperation(value = "货主客户端货主确认生成违约结算单")
    @PostMapping("/saveBreakContractSettlement")
    Result saveBreakContractSettlement(@RequestBody @Validated BreakContractSettlementGenerateAction param){
        breakContractOwnerRecordService.generateBreakContractSettlement(param.getBreakContractId());
        return Result.ok();
    }

}
