package com.clx.performance.feign;

import com.clx.open.sdk.request.action.BreakContractSettlementGenerateAction;
import com.msl.common.result.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "clx-performance",configuration = PerformanceClientConfiguration.class)
public interface SettlementFeign {

    @ApiOperation(value = "查询当前订单号是否已经生成货主结算单明细")
    @GetMapping("clx-performance/feign/settlement/thawAndLockSettlement")
    Result<Boolean> thawAndLockSettlement(@RequestParam String orderNo);

    @ApiOperation(value = "生成违约结算单")
    @PostMapping("clx-performance/feign/breakContract/saveBreakContractSettlement")
    Result saveBreakContractSettlement(@RequestBody @Validated BreakContractSettlementGenerateAction action);

}
