/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.oscca;

import java.security.SecureRandom;

public class SM4 {
    private static final int[] fk = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};
    private static final byte[] Sbox;
    private static final int SM4ROUND = 32;
    private static final int[] CK;
    public static final int SM4_BAD_KEY = 2;
    public static final int SM4_SUCCESS = 0;
    public static final int SM4_BLOCK_SIZE = 16;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -42;
        byArray[1] = -112;
        byArray[2] = -23;
        byArray[3] = -2;
        byArray[4] = -52;
        byArray[5] = -31;
        byArray[6] = 61;
        byArray[7] = -73;
        byArray[8] = 22;
        byArray[9] = -74;
        byArray[10] = 20;
        byArray[11] = -62;
        byArray[12] = 40;
        byArray[13] = -5;
        byArray[14] = 44;
        byArray[15] = 5;
        byArray[16] = 43;
        byArray[17] = 103;
        byArray[18] = -102;
        byArray[19] = 118;
        byArray[20] = 42;
        byArray[21] = -66;
        byArray[22] = 4;
        byArray[23] = -61;
        byArray[24] = -86;
        byArray[25] = 68;
        byArray[26] = 19;
        byArray[27] = 38;
        byArray[28] = 73;
        byArray[29] = -122;
        byArray[30] = 6;
        byArray[31] = -103;
        byArray[32] = -100;
        byArray[33] = 66;
        byArray[34] = 80;
        byArray[35] = -12;
        byArray[36] = -111;
        byArray[37] = -17;
        byArray[38] = -104;
        byArray[39] = 122;
        byArray[40] = 51;
        byArray[41] = 84;
        byArray[42] = 11;
        byArray[43] = 67;
        byArray[44] = -19;
        byArray[45] = -49;
        byArray[46] = -84;
        byArray[47] = 98;
        byArray[48] = -28;
        byArray[49] = -77;
        byArray[50] = 28;
        byArray[51] = -87;
        byArray[52] = -55;
        byArray[53] = 8;
        byArray[54] = -24;
        byArray[55] = -107;
        byArray[56] = -128;
        byArray[57] = -33;
        byArray[58] = -108;
        byArray[59] = -6;
        byArray[60] = 117;
        byArray[61] = -113;
        byArray[62] = 63;
        byArray[63] = -90;
        byArray[64] = 71;
        byArray[65] = 7;
        byArray[66] = -89;
        byArray[67] = -4;
        byArray[68] = -13;
        byArray[69] = 115;
        byArray[70] = 23;
        byArray[71] = -70;
        byArray[72] = -125;
        byArray[73] = 89;
        byArray[74] = 60;
        byArray[75] = 25;
        byArray[76] = -26;
        byArray[77] = -123;
        byArray[78] = 79;
        byArray[79] = -88;
        byArray[80] = 104;
        byArray[81] = 107;
        byArray[82] = -127;
        byArray[83] = -78;
        byArray[84] = 113;
        byArray[85] = 100;
        byArray[86] = -38;
        byArray[87] = -117;
        byArray[88] = -8;
        byArray[89] = -21;
        byArray[90] = 15;
        byArray[91] = 75;
        byArray[92] = 112;
        byArray[93] = 86;
        byArray[94] = -99;
        byArray[95] = 53;
        byArray[96] = 30;
        byArray[97] = 36;
        byArray[98] = 14;
        byArray[99] = 94;
        byArray[100] = 99;
        byArray[101] = 88;
        byArray[102] = -47;
        byArray[103] = -94;
        byArray[104] = 37;
        byArray[105] = 34;
        byArray[106] = 124;
        byArray[107] = 59;
        byArray[108] = 1;
        byArray[109] = 33;
        byArray[110] = 120;
        byArray[111] = -121;
        byArray[112] = -44;
        byArray[114] = 70;
        byArray[115] = 87;
        byArray[116] = -97;
        byArray[117] = -45;
        byArray[118] = 39;
        byArray[119] = 82;
        byArray[120] = 76;
        byArray[121] = 54;
        byArray[122] = 2;
        byArray[123] = -25;
        byArray[124] = -96;
        byArray[125] = -60;
        byArray[126] = -56;
        byArray[127] = -98;
        byArray[128] = -22;
        byArray[129] = -65;
        byArray[130] = -118;
        byArray[131] = -46;
        byArray[132] = 64;
        byArray[133] = -57;
        byArray[134] = 56;
        byArray[135] = -75;
        byArray[136] = -93;
        byArray[137] = -9;
        byArray[138] = -14;
        byArray[139] = -50;
        byArray[140] = -7;
        byArray[141] = 97;
        byArray[142] = 21;
        byArray[143] = -95;
        byArray[144] = -32;
        byArray[145] = -82;
        byArray[146] = 93;
        byArray[147] = -92;
        byArray[148] = -101;
        byArray[149] = 52;
        byArray[150] = 26;
        byArray[151] = 85;
        byArray[152] = -83;
        byArray[153] = -109;
        byArray[154] = 50;
        byArray[155] = 48;
        byArray[156] = -11;
        byArray[157] = -116;
        byArray[158] = -79;
        byArray[159] = -29;
        byArray[160] = 29;
        byArray[161] = -10;
        byArray[162] = -30;
        byArray[163] = 46;
        byArray[164] = -126;
        byArray[165] = 102;
        byArray[166] = -54;
        byArray[167] = 96;
        byArray[168] = -64;
        byArray[169] = 41;
        byArray[170] = 35;
        byArray[171] = -85;
        byArray[172] = 13;
        byArray[173] = 83;
        byArray[174] = 78;
        byArray[175] = 111;
        byArray[176] = -43;
        byArray[177] = -37;
        byArray[178] = 55;
        byArray[179] = 69;
        byArray[180] = -34;
        byArray[181] = -3;
        byArray[182] = -114;
        byArray[183] = 47;
        byArray[184] = 3;
        byArray[185] = -1;
        byArray[186] = 106;
        byArray[187] = 114;
        byArray[188] = 109;
        byArray[189] = 108;
        byArray[190] = 91;
        byArray[191] = 81;
        byArray[192] = -115;
        byArray[193] = 27;
        byArray[194] = -81;
        byArray[195] = -110;
        byArray[196] = -69;
        byArray[197] = -35;
        byArray[198] = -68;
        byArray[199] = 127;
        byArray[200] = 17;
        byArray[201] = -39;
        byArray[202] = 92;
        byArray[203] = 65;
        byArray[204] = 31;
        byArray[205] = 16;
        byArray[206] = 90;
        byArray[207] = -40;
        byArray[208] = 10;
        byArray[209] = -63;
        byArray[210] = 49;
        byArray[211] = -120;
        byArray[212] = -91;
        byArray[213] = -51;
        byArray[214] = 123;
        byArray[215] = -67;
        byArray[216] = 45;
        byArray[217] = 116;
        byArray[218] = -48;
        byArray[219] = 18;
        byArray[220] = -72;
        byArray[221] = -27;
        byArray[222] = -76;
        byArray[223] = -80;
        byArray[224] = -119;
        byArray[225] = 105;
        byArray[226] = -105;
        byArray[227] = 74;
        byArray[228] = 12;
        byArray[229] = -106;
        byArray[230] = 119;
        byArray[231] = 126;
        byArray[232] = 101;
        byArray[233] = -71;
        byArray[234] = -15;
        byArray[235] = 9;
        byArray[236] = -59;
        byArray[237] = 110;
        byArray[238] = -58;
        byArray[239] = -124;
        byArray[240] = 24;
        byArray[241] = -16;
        byArray[242] = 125;
        byArray[243] = -20;
        byArray[244] = 58;
        byArray[245] = -36;
        byArray[246] = 77;
        byArray[247] = 32;
        byArray[248] = 121;
        byArray[249] = -18;
        byArray[250] = 95;
        byArray[251] = 62;
        byArray[252] = -41;
        byArray[253] = -53;
        byArray[254] = 57;
        byArray[255] = 72;
        Sbox = byArray;
        CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};
    }

    private static int trans0(int A) {
        return (Sbox[A >>> 24 & 0xFF] << 24 & 0xFF000000) + (Sbox[A >>> 16 & 0xFF] << 16 & 0xFF0000) + (Sbox[A >>> 8 & 0xFF] << 8 & 0xFF00) + (Sbox[A & 0xFF] & 0xFF);
    }

    private static int ROL(int x, int y) {
        return (x << y | (x & 0xFFFFFFFF) >>> 32 - y) & 0xFFFFFFFF;
    }

    private static int trans1(int x_param) {
        int temp = 0;
        temp = SM4.trans0(x_param);
        return temp ^ SM4.ROL(temp, 2) ^ SM4.ROL(temp, 10) ^ SM4.ROL(temp, 18) ^ SM4.ROL(temp, 24);
    }

    private static int trans2(int input) {
        int temp = 0;
        temp = SM4.trans0(input);
        return temp ^ SM4.ROL(temp, 13) ^ SM4.ROL(temp, 23);
    }

    private static int ansio2i(byte[] xarray, int offset) {
        return (xarray[4 * offset] & 0xFF) << 24 & 0xFF000000 | (xarray[4 * offset + 1] & 0xFF) << 16 & 0xFF0000 | (xarray[4 * offset + 2] & 0xFF) << 8 & 0xFF00 | xarray[4 * offset + 3] & 0xFF & 0xFF;
    }

    public static void sm4_key_exp(byte[] omk, int[] rk) {
        int[] mk = new int[4];
        int[] k = new int[4];
        int i = 0;
        mk[0] = SM4.ansio2i(omk, 0);
        mk[1] = SM4.ansio2i(omk, 1);
        mk[2] = SM4.ansio2i(omk, 2);
        mk[3] = SM4.ansio2i(omk, 3);
        k[0] = mk[0] ^ fk[0];
        k[1] = mk[1] ^ fk[1];
        k[2] = mk[2] ^ fk[2];
        k[3] = mk[3] ^ fk[3];
        i = 0;
        while (i < 32) {
            int n = i & 3;
            k[n] = k[n] ^ SM4.trans2(k[i + 1 & 3] ^ k[i + 2 & 3] ^ k[i + 3 & 3] ^ CK[i]);
            rk[i] = k[i & 3];
            ++i;
        }
    }

    private static void sm4_encrypt_rk(byte[] p_block, int[] rk, byte[] c_block) {
        SM4.sm4_encrypt_rk(p_block, 0, rk, c_block, 0);
    }

    private static void sm4_encrypt_rk(byte[] p_block, int p_offset, int[] rk, byte[] c_block, int c_offset) {
        int[] temp_block = new int[4];
        int i = 0;
        temp_block[0] = p_block[p_offset] << 24 & 0xFF000000 | p_block[1 + p_offset] << 16 & 0xFF0000 | p_block[2 + p_offset] << 8 & 0xFF00 | p_block[3 + p_offset] & 0xFF;
        temp_block[1] = p_block[4 + p_offset] << 24 & 0xFF000000 | p_block[5 + p_offset] << 16 & 0xFF0000 | p_block[6 + p_offset] << 8 & 0xFF00 | p_block[7 + p_offset] & 0xFF;
        temp_block[2] = p_block[8 + p_offset] << 24 & 0xFF000000 | p_block[9 + p_offset] << 16 & 0xFF0000 | p_block[10 + p_offset] << 8 & 0xFF00 | p_block[11 + p_offset] & 0xFF;
        temp_block[3] = p_block[12 + p_offset] << 24 & 0xFF000000 | p_block[13 + p_offset] << 16 & 0xFF0000 | p_block[14 + p_offset] << 8 & 0xFF00 | p_block[15 + p_offset] & 0xFF;
        i = 0;
        while (i < 32) {
            int n = i & 3;
            temp_block[n] = temp_block[n] ^ SM4.trans1(temp_block[i + 1 & 3] ^ temp_block[i + 2 & 3] ^ temp_block[i + 3 & 3] ^ rk[i]);
            ++i;
        }
        c_block[c_offset] = (byte)(temp_block[3] >>> 24 & 0xFF);
        c_block[1 + c_offset] = (byte)(temp_block[3] >>> 16 & 0xFF);
        c_block[2 + c_offset] = (byte)(temp_block[3] >>> 8 & 0xFF);
        c_block[3 + c_offset] = (byte)(temp_block[3] & 0xFF);
        c_block[4 + c_offset] = (byte)(temp_block[2] >>> 24 & 0xFF);
        c_block[5 + c_offset] = (byte)(temp_block[2] >>> 16 & 0xFF);
        c_block[6 + c_offset] = (byte)(temp_block[2] >>> 8 & 0xFF);
        c_block[7 + c_offset] = (byte)(temp_block[2] & 0xFF);
        c_block[8 + c_offset] = (byte)(temp_block[1] >>> 24 & 0xFF);
        c_block[9 + c_offset] = (byte)(temp_block[1] >>> 16 & 0xFF);
        c_block[10 + c_offset] = (byte)(temp_block[1] >>> 8 & 0xFF);
        c_block[11 + c_offset] = (byte)(temp_block[1] & 0xFF);
        c_block[12 + c_offset] = (byte)(temp_block[0] >>> 24 & 0xFF);
        c_block[13 + c_offset] = (byte)(temp_block[0] >>> 16 & 0xFF);
        c_block[14 + c_offset] = (byte)(temp_block[0] >>> 8 & 0xFF);
        c_block[15 + c_offset] = (byte)(temp_block[0] & 0xFF);
    }

    private static void sm4_decrypt_rk(byte[] c_block, int[] rk, byte[] p_block) {
        SM4.sm4_decrypt_rk(c_block, 0, rk, p_block, 0);
    }

    private static void sm4_decrypt_rk(byte[] c_block, int c_offset, int[] rk, byte[] p_block, int p_offset) {
        int[] temp_block = new int[4];
        int i = 0;
        temp_block[0] = c_block[c_offset] << 24 & 0xFF000000 | c_block[1 + c_offset] << 16 & 0xFF0000 | c_block[2 + c_offset] << 8 & 0xFF00 | c_block[3 + c_offset] & 0xFF;
        temp_block[1] = c_block[4 + c_offset] << 24 & 0xFF000000 | c_block[5 + c_offset] << 16 & 0xFF0000 | c_block[6 + c_offset] << 8 & 0xFF00 | c_block[7 + c_offset] & 0xFF;
        temp_block[2] = c_block[8 + c_offset] << 24 & 0xFF000000 | c_block[9 + c_offset] << 16 & 0xFF0000 | c_block[10 + c_offset] << 8 & 0xFF00 | c_block[11 + c_offset] & 0xFF;
        temp_block[3] = c_block[12 + c_offset] << 24 & 0xFF000000 | c_block[13 + c_offset] << 16 & 0xFF0000 | c_block[14 + c_offset] << 8 & 0xFF00 | c_block[15 + c_offset] & 0xFF;
        i = 0;
        while (i < 32) {
            int n = i & 3;
            temp_block[n] = temp_block[n] ^ SM4.trans1(temp_block[i + 1 & 3] ^ temp_block[i + 2 & 3] ^ temp_block[i + 3 & 3] ^ rk[31 - i]);
            ++i;
        }
        p_block[p_offset] = (byte)(temp_block[3] >>> 24 & 0xFF);
        p_block[1 + p_offset] = (byte)(temp_block[3] >>> 16 & 0xFF);
        p_block[2 + p_offset] = (byte)(temp_block[3] >>> 8 & 0xFF);
        p_block[3 + p_offset] = (byte)(temp_block[3] & 0xFF);
        p_block[4 + p_offset] = (byte)(temp_block[2] >>> 24 & 0xFF);
        p_block[5 + p_offset] = (byte)(temp_block[2] >>> 16 & 0xFF);
        p_block[6 + p_offset] = (byte)(temp_block[2] >>> 8 & 0xFF);
        p_block[7 + p_offset] = (byte)(temp_block[2] & 0xFF);
        p_block[8 + p_offset] = (byte)(temp_block[1] >>> 24 & 0xFF);
        p_block[9 + p_offset] = (byte)(temp_block[1] >>> 16 & 0xFF);
        p_block[10 + p_offset] = (byte)(temp_block[1] >>> 8 & 0xFF);
        p_block[11 + p_offset] = (byte)(temp_block[1] & 0xFF);
        p_block[12 + p_offset] = (byte)(temp_block[0] >>> 24 & 0xFF);
        p_block[13 + p_offset] = (byte)(temp_block[0] >>> 16 & 0xFF);
        p_block[14 + p_offset] = (byte)(temp_block[0] >>> 8 & 0xFF);
        p_block[15 + p_offset] = (byte)(temp_block[0] & 0xFF);
    }

    public static int sm4_encrypt(byte[] p_block, byte[] key, int key_len_bytes, byte[] c_block) {
        int[] rk = new int[32];
        if (key_len_bytes != 16) {
            return 2;
        }
        SM4.sm4_key_exp(key, rk);
        SM4.sm4_encrypt_rk(p_block, rk, c_block);
        return 0;
    }

    public static int sm4_decrypt(byte[] c_block, byte[] key, int key_len_bytes, byte[] p_block) {
        int[] rk = new int[32];
        if (key_len_bytes != 16) {
            return 2;
        }
        SM4.sm4_key_exp(key, rk);
        SM4.sm4_decrypt_rk(c_block, rk, p_block);
        return 0;
    }

    public static final int sm4_cbc_encrypt(byte[] in, int in_len_bytes, byte[] out, byte[] key, int key_len_bytes, byte[] ivec) {
        byte[] tr = new byte[16];
        byte[] iv = new byte[16];
        int[] rk = new int[32];
        int pc = in_len_bytes & 0xF;
        int numBlocks = in_len_bytes - pc >>> 4;
        pc = 16 - pc;
        if (key_len_bytes != 16) {
            return 2;
        }
        SM4.sm4_key_exp(key, rk);
        int j = 0;
        while (j < 16) {
            iv[j] = ivec[j];
            ++j;
        }
        int i = 0;
        while (i < numBlocks) {
            j = 0;
            while (j < 16) {
                tr[j] = (byte)(in[j + i * 16] ^ iv[j]);
                ++j;
            }
            SM4.sm4_encrypt_rk(tr, rk, tr);
            j = 0;
            while (j < 16) {
                out[j + i * 16] = tr[j];
                iv[j] = tr[j];
                ++j;
            }
            ++i;
        }
        j = in_len_bytes - numBlocks * 16;
        if (pc == 0) {
            pc = 16;
        }
        i = 0;
        while (i < j) {
            tr[i] = in[numBlocks * 16 + i];
            ++i;
        }
        i = j;
        while (i < 16) {
            tr[i] = (byte)pc;
            ++i;
        }
        i = 0;
        while (i < 16) {
            int n = i;
            tr[n] = (byte)(tr[n] ^ iv[i]);
            ++i;
        }
        SM4.sm4_encrypt_rk(tr, 0, rk, out, numBlocks * 16);
        return 0;
    }

    public static final int sm4_cbc_decrypt(byte[] in, int in_len_bytes, byte[] out, int out_len_bytes, byte[] key, int key_len_bytes, byte[] ivec) {
        byte[] tr = new byte[16];
        byte[] iv = new byte[16];
        int[] rk = new int[32];
        int numBlocks = in_len_bytes >>> 4;
        if (key_len_bytes != 16) {
            return 2;
        }
        SM4.sm4_key_exp(key, rk);
        int i = 0;
        while (i < 16) {
            iv[i] = ivec[i];
            ++i;
        }
        i = 0;
        while (i < numBlocks) {
            int j = 0;
            while (j < 16) {
                tr[j] = in[j + i * 16];
                ++j;
            }
            SM4.sm4_decrypt_rk(tr, rk, tr);
            j = 0;
            while (j < 16) {
                out[j + i * 16] = (byte)(tr[j] ^ iv[j]);
                iv[j] = in[j + i * 16];
                ++j;
            }
            ++i;
        }
        out_len_bytes = in_len_bytes - (out[in_len_bytes - 1] & 0xFF);
        return 0;
    }

    public static final int sm4_ecb_encrypt(byte[] in, int in_len_bytes, byte[] out, byte[] key, int key_len_bytes) {
        int j;
        byte[] tr = new byte[16];
        int[] rk = new int[32];
        int pc = in_len_bytes & 0xF;
        int numBlocks = in_len_bytes - pc >>> 4;
        pc = 16 - pc;
        if (key_len_bytes != 16) {
            return 2;
        }
        SM4.sm4_key_exp(key, rk);
        int i = 0;
        while (i < numBlocks) {
            j = 0;
            while (j < 16) {
                tr[j] = in[i * 16 + j];
                ++j;
            }
            SM4.sm4_encrypt_rk(tr, 0, rk, out, i * 16);
            ++i;
        }
        j = in_len_bytes - numBlocks * 16;
        if (pc == 0) {
            pc = 16;
        }
        i = 0;
        while (i < j) {
            tr[i] = in[numBlocks * 16 + i];
            ++i;
        }
        i = j;
        while (i < 16) {
            tr[i] = (byte)pc;
            ++i;
        }
        SM4.sm4_encrypt_rk(tr, 0, rk, out, numBlocks * 16);
        return 0;
    }

    public static final int sm4_ecb_decrypt(byte[] in, int in_len_bytes, byte[] out, int out_len_bytes, byte[] key, int key_len_bytes) {
        byte[] tr = new byte[16];
        int[] rk = new int[32];
        int numBlocks = in_len_bytes / 16;
        if (key_len_bytes != 16) {
            return 2;
        }
        SM4.sm4_key_exp(key, rk);
        int i = 0;
        while (i < numBlocks) {
            int j = 0;
            while (j < 16) {
                tr[j] = in[j + i * 16];
                ++j;
            }
            SM4.sm4_decrypt_rk(tr, 0, rk, out, i * 16);
            ++i;
        }
        out_len_bytes = in_len_bytes - (out[in_len_bytes - 1] & 0xFF);
        return 0;
    }

    private static final void validation() {
        byte[] key = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -2, -36, -70, -104, 118, 84, 50, 16};
        byte[] pt = new byte[16];
        byte[] ct = new byte[16];
        int[] rk = new int[32];
        SM4.sm4_key_exp(key, rk);
        int i = 0;
        while (i < 16) {
            pt[i] = key[i];
            ++i;
        }
        SM4.sm4_encrypt_rk(pt, rk, ct);
        SM4.sm4_decrypt_rk(ct, rk, pt);
        i = 0;
        while (i < 500000) {
            SM4.sm4_encrypt_rk(pt, rk, ct);
            SM4.sm4_encrypt_rk(ct, rk, pt);
            ++i;
        }
    }

    public static void main(String[] args) {
        byte[] key = new byte[]{-27, -72, 123, 77, -11, -24, 72, 32, 84, 20, 72, -79, 31, 90, -87, 63};
        byte[] IV = new byte[]{18, -92, -73, 57, -18, -102, -62, 67, -105, 36, -40, -64, -15, -89, 57, 113};
        byte[] p1k = new byte[1024];
        byte[] c1k = new byte[1040];
        byte[] p8k = new byte[8192];
        byte[] c8k = new byte[8208];
        int max = 1024;
        System.out.println(String.valueOf(Integer.toBinaryString(-16711936)) + "\n" + Integer.toBinaryString(SM4.ROL(-16711936, 13)));
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            int i = 0;
            while (i < max) {
                p1k[i] = (byte)(sr.nextInt() & 0xFF);
                ++i;
            }
            i = 0;
            while (i < 8192) {
                p8k[i] = (byte)(sr.nextInt() & 0xFF);
                ++i;
            }
            max = 100000;
            long start = System.currentTimeMillis();
            i = 0;
            while (i < max) {
                SM4.sm4_cbc_encrypt(p1k, 1024, c1k, key, 16, IV);
                ++i;
            }
            long end = System.currentTimeMillis();
            System.out.println("1k bytes input, Throughput =" + (double)(max * 1024) * 1.0 / 1024.0 / 1024.0 * 1000.0 / (double)(end - start) + " MBps");
            start = System.currentTimeMillis();
            i = 0;
            while (i < max) {
                SM4.sm4_cbc_encrypt(p8k, 8192, c8k, key, 16, IV);
                ++i;
            }
            end = System.currentTimeMillis();
            System.out.println("8k bytes input, Throughput =" + (double)(max * 1024) * 8.0 / 1024.0 / 1024.0 * 1000.0 / (double)(end - start) + " MBps");
            SM4.validation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

