/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.util.SubjectDNUtil;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x509.Time;
import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.asn1.x509.X509ObjectIdentifiers;

public class TBSCertificateStructure
extends ASN1Encodable
implements X509ObjectIdentifiers,
PKCSObjectIdentifiers {
    ASN1Sequence seq;
    DERInteger version;
    DERInteger serialNumber;
    AlgorithmIdentifier signature;
    X509Name issuer;
    Time startDate;
    Time endDate;
    X509Name subject;
    SubjectPublicKeyInfo subjectPublicKeyInfo;
    DERBitString issuerUniqueId;
    DERBitString subjectUniqueId;
    X509Extensions extensions;

    public static TBSCertificateStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSCertificateStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static TBSCertificateStructure getInstance(Object obj) {
        if (obj instanceof TBSCertificateStructure) {
            return (TBSCertificateStructure)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new TBSCertificateStructure((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public TBSCertificateStructure(ASN1Sequence seq) {
        int seqStart = 0;
        this.seq = seq;
        if (seq.getObjectAt(0) instanceof DERTaggedObject) {
            this.version = DERInteger.getInstance(seq.getObjectAt(0));
        } else {
            seqStart = -1;
            this.version = new DERInteger(0);
        }
        this.serialNumber = DERInteger.getInstance(seq.getObjectAt(seqStart + 1));
        this.signature = AlgorithmIdentifier.getInstance(seq.getObjectAt(seqStart + 2));
        DEREncodable derobj = seq.getObjectAt(seqStart + 3);
        if (derobj instanceof ASN1Sequence) {
            DEREncodable issuerDer = SubjectDNUtil.sortDN((ASN1Sequence)derobj, "cn.com.infosec.jce.SortIssuerDN");
            this.issuer = X509Name.getInstance(issuerDer);
        } else {
            this.issuer = (X509Name)derobj;
        }
        ASN1Sequence dates = (ASN1Sequence)seq.getObjectAt(seqStart + 4);
        this.startDate = Time.getInstance(dates.getObjectAt(0));
        this.endDate = Time.getInstance(dates.getObjectAt(1));
        derobj = seq.getObjectAt(seqStart + 5);
        if (derobj instanceof ASN1Sequence) {
            DEREncodable subjectDer = SubjectDNUtil.sortDN((ASN1Sequence)derobj, "cn.com.infosec.jce.SortDN");
            this.subject = X509Name.getInstance(subjectDer);
        } else {
            this.subject = (X509Name)derobj;
        }
        this.subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(seqStart + 6));
        int extras = seq.size() - (seqStart + 6) - 1;
        while (extras > 0) {
            DERTaggedObject extra = (DERTaggedObject)seq.getObjectAt(seqStart + 6 + extras);
            switch (extra.getTagNo()) {
                case 1: {
                    this.issuerUniqueId = DERBitString.getInstance(extra, false);
                    break;
                }
                case 2: {
                    this.subjectUniqueId = DERBitString.getInstance(extra, false);
                    break;
                }
                case 3: {
                    this.extensions = X509Extensions.getInstance(extra);
                }
            }
            --extras;
        }
    }

    public int getVersion() {
        return this.version.getValue().intValue() + 1;
    }

    public DERInteger getVersionNumber() {
        return this.version;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X509Name getIssuer() {
        return this.issuer;
    }

    public Time getStartDate() {
        return this.startDate;
    }

    public Time getEndDate() {
        return this.endDate;
    }

    public X509Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public DERBitString getIssuerUniqueId() {
        return this.issuerUniqueId;
    }

    public DERBitString getSubjectUniqueId() {
        return this.subjectUniqueId;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }
}

