/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.netsign.crypto.util.SM3;
import cn.com.infosec.oscca.sm2.SM2Util;

public class SM3Util {
    private static byte[] abGxGy;

    static {
        byte[] a = SM2Util.gma.toByteArray();
        byte[] tmp = new byte[32];
        System.arraycopy(a, 1, tmp, 0, 32);
        a = tmp;
        byte[] b = SM2Util.gmb.toByteArray();
        byte[] Gx = SM2Util.gmgx.toByteArray();
        byte[] Gy = SM2Util.gmgy.toByteArray();
        tmp = new byte[32];
        System.arraycopy(Gy, 1, tmp, 0, 32);
        Gy = tmp;
        abGxGy = new byte[a.length + b.length + Gx.length + Gy.length];
        int start = 0;
        System.arraycopy(a, 0, abGxGy, start, a.length);
        System.arraycopy(b, 0, abGxGy, start += a.length, b.length);
        System.arraycopy(Gx, 0, abGxGy, start += b.length, Gx.length);
        System.arraycopy(Gy, 0, abGxGy, start += Gx.length, Gy.length);
    }

    public static byte[] SM3Digest(byte[] puid, byte[] x, byte[] y, byte[] msg) {
        if (puid == null) {
            return SM3.SM3Digest(msg);
        }
        byte[] tmp = SM3Util.connect(puid, x, y);
        byte[] Z = SM3.SM3Digest(tmp);
        tmp = SM3Util.connect(Z, msg);
        return SM3.SM3Digest(tmp);
    }

    public static byte[] connect(byte[] puid, byte[] x, byte[] y) {
        byte[] tmp = new byte[2 + puid.length + abGxGy.length + x.length + y.length];
        int entlen = puid.length * 8;
        byte[] entlenBs = new byte[]{(byte)(0xFF & entlen >> 8), (byte)(0xFF & entlen)};
        int start = 0;
        System.arraycopy(entlenBs, 0, tmp, start, 2);
        System.arraycopy(puid, 0, tmp, start += 2, puid.length);
        System.arraycopy(abGxGy, 0, tmp, start += puid.length, abGxGy.length);
        System.arraycopy(x, 0, tmp, start += abGxGy.length, x.length);
        System.arraycopy(y, 0, tmp, start += x.length, y.length);
        return tmp;
    }

    private static byte[] connect(byte[] Z, byte[] M) {
        byte[] tmp = new byte[Z.length + M.length];
        System.arraycopy(Z, 0, tmp, 0, Z.length);
        System.arraycopy(M, 0, tmp, Z.length, M.length);
        return tmp;
    }
}

