/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.util;

import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.der.util.DERSegment;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import java.io.FileInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;

public class Utils {
    private static Date now = new Date();
    public static final int GET_VERIFY_CERT_ID = 1;
    public static final int GET_SIGNATRURE_ID = 2;
    public static final int CERTIFICATE_TYPE_SM2 = 1;
    public static final int CERTIFICATE_TYPE_OTHER = 99;

    public static String toHexString(byte[] bs) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int length = bs.length;
        while (i < length) {
            int x = bs[i] & 0xFF;
            if (x == 0) {
                buf.append("00");
            } else {
                String hex = Integer.toHexString(x);
                hex = hex.length() % 2 == 0 ? hex : "0" + hex;
                buf.append(hex);
            }
            ++i;
        }
        return buf.toString();
    }

    private static String formatHexString(String hex) {
        hex = hex.trim().replaceAll("0x", "").toUpperCase();
        StringBuilder builder = new StringBuilder();
        char[] chars = hex.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9' || chars[i] >= 'A' && chars[i] <= 'F') {
                builder.append(chars[i]);
            }
            ++i;
        }
        return builder.toString();
    }

    public static byte[] hexString2ByteArray(String hex) {
        byte[] bs = (hex = Utils.formatHexString(hex)).length() % 2 == 0 ? new byte[hex.length() / 2] : new byte[hex.length() / 2 + 1];
        int i = bs.length - 1;
        while (i > -1) {
            String strb = hex.substring(i * 2, i * 2 + 2);
            bs[i] = (byte)(Integer.parseInt(strb, 16) & 0xFF);
            --i;
        }
        return bs;
    }

    public static byte[] generateBytes(int i) {
        byte[] r = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return r;
    }

    public static int generateInt(byte[] bytes) {
        int i1 = bytes[0] & 0xFF;
        int i2 = bytes[1] & 0xFF;
        int i3 = bytes[2] & 0xFF;
        int i4 = bytes[3] & 0xFF;
        return (i1 << 24) + (i2 << 16) + (i3 << 8) + (i4 << 0);
    }

    public static Date getNow() {
        now.setTime(System.currentTimeMillis());
        return now;
    }

    public static byte[] getOSCCApucID(int type, Object[] paras) {
        if (paras == null) {
            switch (type) {
                case 1: {
                    return ExtendedConfig.getSM3pucID();
                }
                case 2: {
                    return ExtendedConfig.getSM3SignpucID();
                }
            }
            return ExtendedConfig.getSM3pucID();
        }
        return null;
    }

    public static int getCertType(X509Certificate cert) {
        try {
            PublicKey pubk = cert.getPublicKey();
            if (pubk instanceof JCESM2PublicKey) {
                return 1;
            }
            return 99;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static int getPublicKeyType(byte[] pubkey) {
        DERSegment pubk = new DERSegment(pubkey);
        DERSegment oid = pubk.getInnerDERSegment().nextDERSegment();
        if (oid.getDERHead().getLengthInt() == 13) {
            return 99;
        }
        return 1;
    }

    public static void main(String[] args) throws Exception {
        FileInputStream in = new FileInputStream("d:/TEMP/5year.cer");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
        System.out.println(Utils.getPublicKeyType(cert.getPublicKey().getEncoded()));
    }
}

