package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
* @Author: aiqinguo
* @Description: 运单日志
* @Date: 2023/09/18 11:43:34
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class OrderChildLog implements HasKey<Integer> {

    private Integer id;                             //id
    private String childNo;                         //运单编号
    private Integer type;                           //类型
    private String remark;                          //内容
    private Integer createType;                     //操作人类型1，货主 2，承运端
    private Long createBy;                          //操作人编号
    private String createName;                      //操作人名称
    private String createTime;                      //创建时间
    private String modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}