package com.clx.performance.dao.impl;

import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Repository
public class OrderGoodsDaoImpl extends BaseDaoImpl<OrderGoodsMapper, OrderGoods, Integer> implements OrderGoodsDao {

    @Override
    public Optional<OrderGoods> getByOrderGoodsNo(String orderGoodsNo) {
        return Optional.of(orderGoodsNo)
                .map(item -> lQrWrapper()
                        .eq(OrderGoods::getUserNo, item)
                )
                .map(super::getOne);
    }

}
