package com.clx.performance.service.impl.loan;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.feign.AddressFeign;
import com.clx.order.feign.LoanPaymentFeign;
import com.clx.order.param.feign.PaymentParam;
import com.clx.order.vo.pc.nbbank.NbBankOrderPayResultVO;
import com.clx.performance.component.IdGenerateSnowFlake;
import com.clx.performance.dao.loan.OwnerPaymentDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.loan.OwnerPaymentEnum;
import com.clx.performance.model.loan.OwnerPayment;
import com.clx.performance.param.pc.loan.carrier.PageCarrierOwnerPaymentParam;
import com.clx.performance.service.loan.OwnerPaymentService;
import com.clx.performance.struct.loan.OwnerPaymentStruct;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerPaymentVO;
import com.clx.performance.vo.pc.loan.carrier.OwnerPaymentVO;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Service
@Slf4j
@AllArgsConstructor
public class OwnerPaymentServiceImpl implements OwnerPaymentService {

    private final OwnerPaymentDao ownerPaymentDao;

    private final OwnerPaymentStruct ownerPaymentStruct;

    private final IdGenerateSnowFlake idGenerateSnowFlake;

    private final LoanPaymentFeign loanPaymentFeign;

    @Override
    public IPage<OwnerPaymentVO> pageOwnerPayment(PageCarrierOwnerPaymentParam param) {
        IPage<OwnerPayment> page = ownerPaymentDao.pageOwnerPayment(param);
        List<OwnerPaymentVO> records = ownerPaymentStruct.convertList(page.getRecords());
        IPage<OwnerPaymentVO> returnPage = new Page<>();
        returnPage.setPages(page.getPages());
        returnPage.setTotal(page.getTotal());
        returnPage.setRecords(records);
        return returnPage;
    }

    @Override
    public CarrierOwnerPaymentVO getOwnerPaymentDetail(Integer id) {
        OwnerPayment ownerPayment = ownerPaymentDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        return ownerPaymentStruct.convert(ownerPayment);
    }

    /**
     * 调用财资支付
     *
     * @param id
     */
    @Override
    public void pay(Integer id) {
        OwnerPayment ownerPayment = ownerPaymentDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        if (!OwnerPaymentEnum.Status.PAY_WAIT.getCode().equals(ownerPayment.getStatus())) {
            throw new ServiceSystemException(PerformanceResultEnum.OWNER_LOAN_PAYMENT_STATUS_ERROR);
        }
        String merSeqNo = idGenerateSnowFlake.nextIdToString(1L);
        PaymentParam param = new PaymentParam();
        param.setAmount(Integer.parseInt(ownerPayment.getPaymentBalance().toString()));
        param.setMerSeqNo(merSeqNo);
        param.setPayAcc(ownerPayment.getPaymentAccount());
        param.setRcvAcc(ownerPayment.getPayeeAccount());
        param.setRcvName(ownerPayment.getPayee());
        param.setRcvBankId(ownerPayment.getPayeeBankCode());
        Result<NbBankOrderPayResultVO> result = loanPaymentFeign.pay(param);
        if (!result.succeed()) {
            throw new ServiceSystemException(PerformanceResultEnum.OWNER_LOAN_PAY_STATUS_ERROR);
        }
        ownerPayment.setMerchantRunningWaterNo(merSeqNo);
        ownerPayment.setStatus(OwnerPaymentEnum.Status.PAYING.getCode());
        ownerPaymentDao.updateStatusAndMerchantRunningWaterNo(ownerPayment);

    }
}
