package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 17:05
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_loan_record")
public class OwnerLoanRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("owner_user_no")
    @ApiModelProperty("货主编码")
    private Long ownerUserNo;

    @TableField("owner_user_name")
    @ApiModelProperty("货主名称")
    private String ownerUserName;

    @TableField("mobile")
    @ApiModelProperty("联系电话")
    private String mobile;

    @TableField("goods_name")
    @ApiModelProperty("货物名称")
    private String goodsName;

    @TableField("running_water_open_no")
    @ApiModelProperty("交易流水号（第三方）")
    private String runningWaterOpenNo;

    @TableField("merchant_running_water_no")
    @ApiModelProperty("商户流水号")
    private String merchantRunningWaterNo;

    @TableField("loan_no")
    @ApiModelProperty("借款单号")
    private Long loanNo;

    @TableField("loan_type")
    @ApiModelProperty("借款类型 1:虚拟货币  2:资金")
    private Integer loanType;

    @TableField("loan_balance")
    @ApiModelProperty("借款金额")
    private BigDecimal loanBalance;

    @TableField("loan_residue_balance")
    @ApiModelProperty("借款剩余金额")
    private BigDecimal loanResidueBalance;


    @TableField("borrower_id")
    @ApiModelProperty("借出方Id")
    private Integer borrowerId;

    @TableField("borrower")
    @ApiModelProperty("借出方")
    private String borrower;

    @ApiModelProperty("借出方账户")
    @TableField("borrower_account")
    private String borrowerAccount;


    @TableField("borrower_bank")
    @ApiModelProperty("借出方银行")
    private String borrowerBank;

    @TableField("borrower_bank_code")
    @ApiModelProperty("借出方银行行号")
    private String borrowerBankCode;

    @TableField("borrower_open_bank")
    @ApiModelProperty("借出方开户行")
    private String borrowerOpenBank;

    @TableField("remittance_identification_code")
    @ApiModelProperty("汇款识别码")
    private String remittanceIdentificationCode;


    @TableField("lending_party")
    @ApiModelProperty("借款方")
    private String lendingParty;

    @TableField("lending_party_account")
    @ApiModelProperty("借款方账户")
    private String lendingPartyAccount;

    @TableField("lending_party_bank")
    @ApiModelProperty("借款方银行")
    private String lendingPartyBank;

    @TableField("lending_party_bank_code")
    @ApiModelProperty("借款方银行行号")
    private String lendingPartyBankCode;

    @TableField("lending_party_open_bank")
    @ApiModelProperty("借款方开户行")
    private String lendingPartyOpenBank;



    @TableField("payee")
    @ApiModelProperty("收款方")
    private String payee;

    @TableField("payee_account")
    @ApiModelProperty("收款账户")
    private String payeeAccount;

    @TableField("payee_bank")
    @ApiModelProperty("收款银行")
    private String payeeBank;

    @TableField("payee_bank_code")
    @ApiModelProperty("收款行号")
    private String payeeBankCode;

    @TableField("status")
    @ApiModelProperty("10 待审批 15 待付款 20 审批通过   30 审批拒绝  40 付款中  50 付款成功 60 付款失败 ")
    private Integer status;

    @TableField("approve_time")
    @ApiModelProperty("审批时间")
    private LocalDateTime approveTime;

    @TableField("approve_by")
    @ApiModelProperty("审批人")
    private String approveBy;

    @TableField("reject_reason")
    @ApiModelProperty("拒绝原因")
    private String rejectReason;

    @TableField("loan_repayment_time")
    @ApiModelProperty("借款归还时间")
    private LocalDateTime loanRepaymentTime;


    @TableField("pay_channel")
    @ApiModelProperty("支付渠道 1 订单支付 2 转账支付")
    private Integer payChannel;


    @TableField("close_order_time")
    @ApiModelProperty("[转账支付]时有关单时间字段 yyyy-MM-dd HH:mm:ss")
    private String closeOrderTime;


    @TableField("create_by")
    @ApiModelProperty("创建人")
    private String createBy;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
